/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.InferTrainedModelResponse;
import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdate;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferTrainedModelRequest
extends RequestBase
implements JsonpSerializable {
    private final List<Map<String, JsonData>> docs;
    @Nullable
    private final InferenceConfigUpdate inferenceConfig;
    private final String modelId;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<InferTrainedModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferTrainedModelRequest::setupInferTrainedModelRequestDeserializer);
    public static final Endpoint<InferTrainedModelRequest, InferTrainedModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<InferTrainedModelRequest, InferTrainedModelResponse>("es/ml.infer_trained_model", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/_infer");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_infer");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, InferTrainedModelResponse._DESERIALIZER);

    private InferTrainedModelRequest(Builder builder) {
        this.docs = ApiTypeHelper.unmodifiableRequired(builder.docs, (Object)this, "docs");
        this.inferenceConfig = builder.inferenceConfig;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.timeout = builder.timeout;
    }

    public static InferTrainedModelRequest of(Function<Builder, ObjectBuilder<InferTrainedModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Map<String, JsonData>> docs() {
        return this.docs;
    }

    @Nullable
    public final InferenceConfigUpdate inferenceConfig() {
        return this.inferenceConfig;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.docs)) {
            generator.writeKey("docs");
            generator.writeStartArray();
            for (Map<String, JsonData> item0 : this.docs) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, JsonData> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
    }

    protected static void setupInferTrainedModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "docs");
        op.add(Builder::inferenceConfig, InferenceConfigUpdate._DESERIALIZER, "inference_config");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferTrainedModelRequest> {
        private List<Map<String, JsonData>> docs;
        @Nullable
        private InferenceConfigUpdate inferenceConfig;
        private String modelId;
        @Nullable
        private Time timeout;

        public final Builder docs(List<Map<String, JsonData>> list) {
            this.docs = Builder._listAddAll(this.docs, list);
            return this;
        }

        public final Builder docs(Map<String, JsonData> value, Map<String, JsonData> ... values) {
            this.docs = Builder._listAdd(this.docs, value, values);
            return this;
        }

        public final Builder inferenceConfig(@Nullable InferenceConfigUpdate value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceConfigUpdate.Builder, ObjectBuilder<InferenceConfigUpdate>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfigUpdate.Builder()).build());
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferTrainedModelRequest build() {
            this._checkSingleUse();
            return new InferTrainedModelRequest(this);
        }
    }
}

