/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.KeyedProcessor;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IngestTotal
implements JsonpSerializable {
    @Nullable
    private final Long count;
    @Nullable
    private final Long current;
    @Nullable
    private final Long failed;
    private final List<Map<String, KeyedProcessor>> processors;
    @Nullable
    private final Long timeInMillis;
    public static final JsonpDeserializer<IngestTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestTotal::setupIngestTotalDeserializer);

    private IngestTotal(Builder builder) {
        this.count = builder.count;
        this.current = builder.current;
        this.failed = builder.failed;
        this.processors = ApiTypeHelper.unmodifiable(builder.processors);
        this.timeInMillis = builder.timeInMillis;
    }

    public static IngestTotal of(Function<Builder, ObjectBuilder<IngestTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long count() {
        return this.count;
    }

    @Nullable
    public final Long current() {
        return this.current;
    }

    @Nullable
    public final Long failed() {
        return this.failed;
    }

    public final List<Map<String, KeyedProcessor>> processors() {
        return this.processors;
    }

    @Nullable
    public final Long timeInMillis() {
        return this.timeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.count != null) {
            generator.writeKey("count");
            generator.write(this.count.longValue());
        }
        if (this.current != null) {
            generator.writeKey("current");
            generator.write(this.current.longValue());
        }
        if (this.failed != null) {
            generator.writeKey("failed");
            generator.write(this.failed.longValue());
        }
        if (ApiTypeHelper.isDefined(this.processors)) {
            generator.writeKey("processors");
            generator.writeStartArray();
            for (Map<String, KeyedProcessor> item0 : this.processors) {
                generator.writeStartObject();
                if (item0 != null) {
                    for (Map.Entry<String, KeyedProcessor> item1 : item0.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.timeInMillis != null) {
            generator.writeKey("time_in_millis");
            generator.write(this.timeInMillis.longValue());
        }
    }

    protected static void setupIngestTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::current, JsonpDeserializer.longDeserializer(), "current");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::processors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(KeyedProcessor._DESERIALIZER)), "processors");
        op.add(Builder::timeInMillis, JsonpDeserializer.longDeserializer(), "time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IngestTotal> {
        @Nullable
        private Long count;
        @Nullable
        private Long current;
        @Nullable
        private Long failed;
        @Nullable
        private List<Map<String, KeyedProcessor>> processors;
        @Nullable
        private Long timeInMillis;

        public final Builder count(@Nullable Long value) {
            this.count = value;
            return this;
        }

        public final Builder current(@Nullable Long value) {
            this.current = value;
            return this;
        }

        public final Builder failed(@Nullable Long value) {
            this.failed = value;
            return this;
        }

        public final Builder processors(List<Map<String, KeyedProcessor>> list) {
            this.processors = Builder._listAddAll(this.processors, list);
            return this;
        }

        public final Builder processors(Map<String, KeyedProcessor> value, Map<String, KeyedProcessor> ... values) {
            this.processors = Builder._listAdd(this.processors, value, values);
            return this;
        }

        public final Builder timeInMillis(@Nullable Long value) {
            this.timeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IngestTotal build() {
            this._checkSingleUse();
            return new IngestTotal(this);
        }
    }
}

