/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.field_usage_stats;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.field_usage_stats.UsageStatsIndex;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class FieldsUsageBody
implements JsonpSerializable {
    private final Map<String, UsageStatsIndex> stats;
    private final ShardStatistics shards;

    protected FieldsUsageBody(AbstractBuilder<?> builder) {
        this.stats = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).stats);
        this.shards = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).shards, this, "shards");
    }

    public final Map<String, UsageStatsIndex> stats() {
        return this.stats;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, UsageStatsIndex> item0 : this.stats.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupFieldsUsageBodyDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.stats((String)name, UsageStatsIndex._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Map<String, UsageStatsIndex> stats = new HashMap<String, UsageStatsIndex>();
        private ShardStatistics shards;

        protected AbstractBuilder() {
        }

        public final BuilderT stats(Map<String, UsageStatsIndex> map) {
            this.stats = AbstractBuilder._mapPutAll(this.stats, map);
            return (BuilderT)this.self();
        }

        public final BuilderT stats(String key, UsageStatsIndex value) {
            this.stats = AbstractBuilder._mapPut(this.stats, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT stats(String key, Function<UsageStatsIndex.Builder, ObjectBuilder<UsageStatsIndex>> fn) {
            return this.stats(key, fn.apply(new UsageStatsIndex.Builder()).build());
        }

        public final BuilderT shards(ShardStatistics value) {
            this.shards = value;
            return (BuilderT)this.self();
        }

        public final BuilderT shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

