/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.explain.Explanation;
import co.elastic.clients.elasticsearch.core.search.InnerHitsResult;
import co.elastic.clients.elasticsearch.core.search.NestedIdentity;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Hit<TDocument>
implements JsonpSerializable {
    private final String index;
    private final String id;
    @Nullable
    private final Double score;
    @Nullable
    private final Explanation explanation;
    private final Map<String, JsonData> fields;
    private final Map<String, List<String>> highlight;
    private final Map<String, InnerHitsResult> innerHits;
    private final List<String> matchedQueries;
    @Nullable
    private final NestedIdentity nested;
    private final List<String> ignored;
    private final Map<String, List<String>> ignoredFieldValues;
    @Nullable
    private final String shard;
    @Nullable
    private final String node;
    @Nullable
    private final String routing;
    @Nullable
    private final TDocument source;
    @Nullable
    private final Long seqNo;
    @Nullable
    private final Long primaryTerm;
    @Nullable
    private final Long version;
    private final List<String> sort;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<Hit<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> Hit.createHitDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.search._types.TDocument")));

    private Hit(Builder<TDocument> builder) {
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.id = ApiTypeHelper.requireNonNull(((Builder)builder).id, this, "id");
        this.score = ((Builder)builder).score;
        this.explanation = ((Builder)builder).explanation;
        this.fields = ApiTypeHelper.unmodifiable(((Builder)builder).fields);
        this.highlight = ApiTypeHelper.unmodifiable(((Builder)builder).highlight);
        this.innerHits = ApiTypeHelper.unmodifiable(((Builder)builder).innerHits);
        this.matchedQueries = ApiTypeHelper.unmodifiable(((Builder)builder).matchedQueries);
        this.nested = ((Builder)builder).nested;
        this.ignored = ApiTypeHelper.unmodifiable(((Builder)builder).ignored);
        this.ignoredFieldValues = ApiTypeHelper.unmodifiable(((Builder)builder).ignoredFieldValues);
        this.shard = ((Builder)builder).shard;
        this.node = ((Builder)builder).node;
        this.routing = ((Builder)builder).routing;
        this.source = ((Builder)builder).source;
        this.seqNo = ((Builder)builder).seqNo;
        this.primaryTerm = ((Builder)builder).primaryTerm;
        this.version = ((Builder)builder).version;
        this.sort = ApiTypeHelper.unmodifiable(((Builder)builder).sort);
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> Hit<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<Hit<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Double score() {
        return this.score;
    }

    @Nullable
    public final Explanation explanation() {
        return this.explanation;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    public final Map<String, List<String>> highlight() {
        return this.highlight;
    }

    public final Map<String, InnerHitsResult> innerHits() {
        return this.innerHits;
    }

    public final List<String> matchedQueries() {
        return this.matchedQueries;
    }

    @Nullable
    public final NestedIdentity nested() {
        return this.nested;
    }

    public final List<String> ignored() {
        return this.ignored;
    }

    public final Map<String, List<String>> ignoredFieldValues() {
        return this.ignoredFieldValues;
    }

    @Nullable
    public final String shard() {
        return this.shard;
    }

    @Nullable
    public final String node() {
        return this.node;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final TDocument source() {
        return this.source;
    }

    @Nullable
    public final Long seqNo() {
        return this.seqNo;
    }

    @Nullable
    public final Long primaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    public final List<String> sort() {
        return this.sort;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_index");
        generator.write(this.index);
        generator.writeKey("_id");
        generator.write(this.id);
        if (this.score != null) {
            generator.writeKey("_score");
            JsonpUtils.serializeDoubleOrNull(generator, this.score, Double.NaN);
        }
        if (this.explanation != null) {
            generator.writeKey("_explanation");
            this.explanation.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.fields.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.highlight)) {
            generator.writeKey("highlight");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.highlight.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.innerHits)) {
            generator.writeKey("inner_hits");
            generator.writeStartObject();
            for (Map.Entry entry : this.innerHits.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((InnerHitsResult)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.matchedQueries)) {
            generator.writeKey("matched_queries");
            generator.writeStartArray();
            for (String string : this.matchedQueries) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.nested != null) {
            generator.writeKey("_nested");
            this.nested.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.ignored)) {
            generator.writeKey("_ignored");
            generator.writeStartArray();
            for (String string : this.ignored) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ignoredFieldValues)) {
            generator.writeKey("ignored_field_values");
            generator.writeStartObject();
            for (Map.Entry entry : this.ignoredFieldValues.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (String item1 : (List)entry.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.shard != null) {
            generator.writeKey("_shard");
            generator.write(this.shard);
        }
        if (this.node != null) {
            generator.writeKey("_node");
            generator.write(this.node);
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            generator.write(this.routing);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            JsonpUtils.serialize(this.source, generator, this.tDocumentSerializer, mapper);
        }
        if (this.seqNo != null) {
            generator.writeKey("_seq_no");
            generator.write(this.seqNo.longValue());
        }
        if (this.primaryTerm != null) {
            generator.writeKey("_primary_term");
            generator.write(this.primaryTerm.longValue());
        }
        if (this.version != null) {
            generator.writeKey("_version");
            generator.write(this.version.longValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (String string : this.sort) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public static <TDocument> JsonpDeserializer<Hit<TDocument>> createHitDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> Hit.setupHitDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupHitDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::score, JsonpDeserializer.doubleOrNullDeserializer(Double.NaN), "_score");
        op.add(Builder::explanation, Explanation._DESERIALIZER, "_explanation");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(Builder::highlight, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "highlight");
        op.add(Builder::innerHits, JsonpDeserializer.stringMapDeserializer(InnerHitsResult._DESERIALIZER), "inner_hits");
        op.add(Builder::matchedQueries, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "matched_queries");
        op.add(Builder::nested, NestedIdentity._DESERIALIZER, "_nested");
        op.add(Builder::ignored, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "_ignored");
        op.add(Builder::ignoredFieldValues, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "ignored_field_values");
        op.add(Builder::shard, JsonpDeserializer.stringDeserializer(), "_shard");
        op.add(Builder::node, JsonpDeserializer.stringDeserializer(), "_node");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "_routing");
        op.add(Builder::source, tDocumentDeserializer, "_source");
        op.add(Builder::seqNo, JsonpDeserializer.longDeserializer(), "_seq_no");
        op.add(Builder::primaryTerm, JsonpDeserializer.longDeserializer(), "_primary_term");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "_version");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "sort");
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<Hit<TDocument>> {
        private String index;
        private String id;
        @Nullable
        private Double score;
        @Nullable
        private Explanation explanation;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Map<String, List<String>> highlight;
        @Nullable
        private Map<String, InnerHitsResult> innerHits;
        @Nullable
        private List<String> matchedQueries;
        @Nullable
        private NestedIdentity nested;
        @Nullable
        private List<String> ignored;
        @Nullable
        private Map<String, List<String>> ignoredFieldValues;
        @Nullable
        private String shard;
        @Nullable
        private String node;
        @Nullable
        private String routing;
        @Nullable
        private TDocument source;
        @Nullable
        private Long seqNo;
        @Nullable
        private Long primaryTerm;
        @Nullable
        private Long version;
        @Nullable
        private List<String> sort;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> id(String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> score(@Nullable Double value) {
            this.score = value;
            return this;
        }

        public final Builder<TDocument> explanation(@Nullable Explanation value) {
            this.explanation = value;
            return this;
        }

        public final Builder<TDocument> explanation(Function<Explanation.Builder, ObjectBuilder<Explanation>> fn) {
            return this.explanation(fn.apply(new Explanation.Builder()).build());
        }

        public final Builder<TDocument> fields(Map<String, JsonData> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder<TDocument> fields(String key, JsonData value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder<TDocument> highlight(Map<String, List<String>> map) {
            this.highlight = Builder._mapPutAll(this.highlight, map);
            return this;
        }

        public final Builder<TDocument> highlight(String key, List<String> value) {
            this.highlight = Builder._mapPut(this.highlight, key, value);
            return this;
        }

        public final Builder<TDocument> innerHits(Map<String, InnerHitsResult> map) {
            this.innerHits = Builder._mapPutAll(this.innerHits, map);
            return this;
        }

        public final Builder<TDocument> innerHits(String key, InnerHitsResult value) {
            this.innerHits = Builder._mapPut(this.innerHits, key, value);
            return this;
        }

        public final Builder<TDocument> innerHits(String key, Function<InnerHitsResult.Builder, ObjectBuilder<InnerHitsResult>> fn) {
            return this.innerHits(key, fn.apply(new InnerHitsResult.Builder()).build());
        }

        public final Builder<TDocument> matchedQueries(List<String> list) {
            this.matchedQueries = Builder._listAddAll(this.matchedQueries, list);
            return this;
        }

        public final Builder<TDocument> matchedQueries(String value, String ... values) {
            this.matchedQueries = Builder._listAdd(this.matchedQueries, value, values);
            return this;
        }

        public final Builder<TDocument> nested(@Nullable NestedIdentity value) {
            this.nested = value;
            return this;
        }

        public final Builder<TDocument> nested(Function<NestedIdentity.Builder, ObjectBuilder<NestedIdentity>> fn) {
            return this.nested(fn.apply(new NestedIdentity.Builder()).build());
        }

        public final Builder<TDocument> ignored(List<String> list) {
            this.ignored = Builder._listAddAll(this.ignored, list);
            return this;
        }

        public final Builder<TDocument> ignored(String value, String ... values) {
            this.ignored = Builder._listAdd(this.ignored, value, values);
            return this;
        }

        public final Builder<TDocument> ignoredFieldValues(Map<String, List<String>> map) {
            this.ignoredFieldValues = Builder._mapPutAll(this.ignoredFieldValues, map);
            return this;
        }

        public final Builder<TDocument> ignoredFieldValues(String key, List<String> value) {
            this.ignoredFieldValues = Builder._mapPut(this.ignoredFieldValues, key, value);
            return this;
        }

        public final Builder<TDocument> shard(@Nullable String value) {
            this.shard = value;
            return this;
        }

        public final Builder<TDocument> node(@Nullable String value) {
            this.node = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> source(@Nullable TDocument value) {
            this.source = value;
            return this;
        }

        public final Builder<TDocument> seqNo(@Nullable Long value) {
            this.seqNo = value;
            return this;
        }

        public final Builder<TDocument> primaryTerm(@Nullable Long value) {
            this.primaryTerm = value;
            return this;
        }

        public final Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder<TDocument> sort(List<String> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder<TDocument> sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public Hit<TDocument> build() {
            this._checkSingleUse();
            return new Hit(this);
        }
    }
}

