/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class PutClusterSettingsResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final Map<String, JsonData> persistent;
    private final Map<String, JsonData> transient_;
    public static final JsonpDeserializer<PutClusterSettingsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutClusterSettingsResponse::setupPutClusterSettingsResponseDeserializer);

    private PutClusterSettingsResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, this, "acknowledged");
        this.persistent = ApiTypeHelper.unmodifiableRequired(builder.persistent, (Object)this, "persistent");
        this.transient_ = ApiTypeHelper.unmodifiableRequired(builder.transient_, (Object)this, "transient_");
    }

    public static PutClusterSettingsResponse of(Function<Builder, ObjectBuilder<PutClusterSettingsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final Map<String, JsonData> persistent() {
        return this.persistent;
    }

    public final Map<String, JsonData> transient_() {
        return this.transient_;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        if (ApiTypeHelper.isDefined(this.persistent)) {
            generator.writeKey("persistent");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.persistent.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.transient_)) {
            generator.writeKey("transient");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.transient_.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutClusterSettingsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::persistent, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "persistent");
        op.add(Builder::transient_, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PutClusterSettingsResponse> {
        private Boolean acknowledged;
        private Map<String, JsonData> persistent;
        private Map<String, JsonData> transient_;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder persistent(Map<String, JsonData> map) {
            this.persistent = Builder._mapPutAll(this.persistent, map);
            return this;
        }

        public final Builder persistent(String key, JsonData value) {
            this.persistent = Builder._mapPut(this.persistent, key, value);
            return this;
        }

        public final Builder transient_(Map<String, JsonData> map) {
            this.transient_ = Builder._mapPutAll(this.transient_, map);
            return this;
        }

        public final Builder transient_(String key, JsonData value) {
            this.transient_ = Builder._mapPut(this.transient_, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutClusterSettingsResponse build() {
            this._checkSingleUse();
            return new PutClusterSettingsResponse(this);
        }
    }
}

