/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.GeoLinePoint;
import co.elastic.clients.elasticsearch._types.aggregations.GeoLineSort;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoLineAggregation
implements AggregationVariant,
JsonpSerializable {
    private final GeoLinePoint point;
    @Nullable
    private final GeoLineSort sort;
    @Nullable
    private final Boolean includeSort;
    @Nullable
    private final SortOrder sortOrder;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GeoLineAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoLineAggregation::setupGeoLineAggregationDeserializer);

    private GeoLineAggregation(Builder builder) {
        this.point = ApiTypeHelper.requireNonNull(builder.point, this, "point");
        this.sort = builder.sort;
        this.includeSort = builder.includeSort;
        this.sortOrder = builder.sortOrder;
        this.size = builder.size;
    }

    public static GeoLineAggregation of(Function<Builder, ObjectBuilder<GeoLineAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeoLine;
    }

    public final GeoLinePoint point() {
        return this.point;
    }

    @Nullable
    public final GeoLineSort sort() {
        return this.sort;
    }

    @Nullable
    public final Boolean includeSort() {
        return this.includeSort;
    }

    @Nullable
    public final SortOrder sortOrder() {
        return this.sortOrder;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("point");
        this.point.serialize(generator, mapper);
        if (this.sort != null) {
            generator.writeKey("sort");
            this.sort.serialize(generator, mapper);
        }
        if (this.includeSort != null) {
            generator.writeKey("include_sort");
            generator.write(this.includeSort.booleanValue());
        }
        if (this.sortOrder != null) {
            generator.writeKey("sort_order");
            this.sortOrder.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGeoLineAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::point, GeoLinePoint._DESERIALIZER, "point");
        op.add(Builder::sort, GeoLineSort._DESERIALIZER, "sort");
        op.add(Builder::includeSort, JsonpDeserializer.booleanDeserializer(), "include_sort");
        op.add(Builder::sortOrder, SortOrder._DESERIALIZER, "sort_order");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GeoLineAggregation> {
        private GeoLinePoint point;
        @Nullable
        private GeoLineSort sort;
        @Nullable
        private Boolean includeSort;
        @Nullable
        private SortOrder sortOrder;
        @Nullable
        private Integer size;

        public final Builder point(GeoLinePoint value) {
            this.point = value;
            return this;
        }

        public final Builder point(Function<GeoLinePoint.Builder, ObjectBuilder<GeoLinePoint>> fn) {
            return this.point(fn.apply(new GeoLinePoint.Builder()).build());
        }

        public final Builder sort(@Nullable GeoLineSort value) {
            this.sort = value;
            return this;
        }

        public final Builder sort(Function<GeoLineSort.Builder, ObjectBuilder<GeoLineSort>> fn) {
            return this.sort(fn.apply(new GeoLineSort.Builder()).build());
        }

        public final Builder includeSort(@Nullable Boolean value) {
            this.includeSort = value;
            return this;
        }

        public final Builder sortOrder(@Nullable SortOrder value) {
            this.sortOrder = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoLineAggregation build() {
            this._checkSingleUse();
            return new GeoLineAggregation(this);
        }
    }
}

