/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BoxPlotAggregate
extends AggregateBase
implements AggregateVariant {
    private final double min;
    private final double max;
    private final double q1;
    private final double q2;
    private final double q3;
    private final double lower;
    private final double upper;
    @Nullable
    private final String minAsString;
    @Nullable
    private final String maxAsString;
    @Nullable
    private final String q1AsString;
    @Nullable
    private final String q2AsString;
    @Nullable
    private final String q3AsString;
    @Nullable
    private final String lowerAsString;
    @Nullable
    private final String upperAsString;
    public static final JsonpDeserializer<BoxPlotAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoxPlotAggregate::setupBoxPlotAggregateDeserializer);

    private BoxPlotAggregate(Builder builder) {
        super(builder);
        this.min = ApiTypeHelper.requireNonNull(builder.min, (Object)this, "min", 0.0);
        this.max = ApiTypeHelper.requireNonNull(builder.max, (Object)this, "max", 0.0);
        this.q1 = ApiTypeHelper.requireNonNull(builder.q1, (Object)this, "q1", 0.0);
        this.q2 = ApiTypeHelper.requireNonNull(builder.q2, (Object)this, "q2", 0.0);
        this.q3 = ApiTypeHelper.requireNonNull(builder.q3, (Object)this, "q3", 0.0);
        this.lower = ApiTypeHelper.requireNonNull(builder.lower, (Object)this, "lower", 0.0);
        this.upper = ApiTypeHelper.requireNonNull(builder.upper, (Object)this, "upper", 0.0);
        this.minAsString = builder.minAsString;
        this.maxAsString = builder.maxAsString;
        this.q1AsString = builder.q1AsString;
        this.q2AsString = builder.q2AsString;
        this.q3AsString = builder.q3AsString;
        this.lowerAsString = builder.lowerAsString;
        this.upperAsString = builder.upperAsString;
    }

    public static BoxPlotAggregate of(Function<Builder, ObjectBuilder<BoxPlotAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.Boxplot;
    }

    public final double min() {
        return this.min;
    }

    public final double max() {
        return this.max;
    }

    public final double q1() {
        return this.q1;
    }

    public final double q2() {
        return this.q2;
    }

    public final double q3() {
        return this.q3;
    }

    public final double lower() {
        return this.lower;
    }

    public final double upper() {
        return this.upper;
    }

    @Nullable
    public final String minAsString() {
        return this.minAsString;
    }

    @Nullable
    public final String maxAsString() {
        return this.maxAsString;
    }

    @Nullable
    public final String q1AsString() {
        return this.q1AsString;
    }

    @Nullable
    public final String q2AsString() {
        return this.q2AsString;
    }

    @Nullable
    public final String q3AsString() {
        return this.q3AsString;
    }

    @Nullable
    public final String lowerAsString() {
        return this.lowerAsString;
    }

    @Nullable
    public final String upperAsString() {
        return this.upperAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("min");
        generator.write(this.min);
        generator.writeKey("max");
        generator.write(this.max);
        generator.writeKey("q1");
        generator.write(this.q1);
        generator.writeKey("q2");
        generator.write(this.q2);
        generator.writeKey("q3");
        generator.write(this.q3);
        generator.writeKey("lower");
        generator.write(this.lower);
        generator.writeKey("upper");
        generator.write(this.upper);
        if (this.minAsString != null) {
            generator.writeKey("min_as_string");
            generator.write(this.minAsString);
        }
        if (this.maxAsString != null) {
            generator.writeKey("max_as_string");
            generator.write(this.maxAsString);
        }
        if (this.q1AsString != null) {
            generator.writeKey("q1_as_string");
            generator.write(this.q1AsString);
        }
        if (this.q2AsString != null) {
            generator.writeKey("q2_as_string");
            generator.write(this.q2AsString);
        }
        if (this.q3AsString != null) {
            generator.writeKey("q3_as_string");
            generator.write(this.q3AsString);
        }
        if (this.lowerAsString != null) {
            generator.writeKey("lower_as_string");
            generator.write(this.lowerAsString);
        }
        if (this.upperAsString != null) {
            generator.writeKey("upper_as_string");
            generator.write(this.upperAsString);
        }
    }

    protected static void setupBoxPlotAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::min, JsonpDeserializer.doubleDeserializer(), "min");
        op.add(Builder::max, JsonpDeserializer.doubleDeserializer(), "max");
        op.add(Builder::q1, JsonpDeserializer.doubleDeserializer(), "q1");
        op.add(Builder::q2, JsonpDeserializer.doubleDeserializer(), "q2");
        op.add(Builder::q3, JsonpDeserializer.doubleDeserializer(), "q3");
        op.add(Builder::lower, JsonpDeserializer.doubleDeserializer(), "lower");
        op.add(Builder::upper, JsonpDeserializer.doubleDeserializer(), "upper");
        op.add(Builder::minAsString, JsonpDeserializer.stringDeserializer(), "min_as_string");
        op.add(Builder::maxAsString, JsonpDeserializer.stringDeserializer(), "max_as_string");
        op.add(Builder::q1AsString, JsonpDeserializer.stringDeserializer(), "q1_as_string");
        op.add(Builder::q2AsString, JsonpDeserializer.stringDeserializer(), "q2_as_string");
        op.add(Builder::q3AsString, JsonpDeserializer.stringDeserializer(), "q3_as_string");
        op.add(Builder::lowerAsString, JsonpDeserializer.stringDeserializer(), "lower_as_string");
        op.add(Builder::upperAsString, JsonpDeserializer.stringDeserializer(), "upper_as_string");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BoxPlotAggregate> {
        private Double min;
        private Double max;
        private Double q1;
        private Double q2;
        private Double q3;
        private Double lower;
        private Double upper;
        @Nullable
        private String minAsString;
        @Nullable
        private String maxAsString;
        @Nullable
        private String q1AsString;
        @Nullable
        private String q2AsString;
        @Nullable
        private String q3AsString;
        @Nullable
        private String lowerAsString;
        @Nullable
        private String upperAsString;

        public final Builder min(double value) {
            this.min = value;
            return this;
        }

        public final Builder max(double value) {
            this.max = value;
            return this;
        }

        public final Builder q1(double value) {
            this.q1 = value;
            return this;
        }

        public final Builder q2(double value) {
            this.q2 = value;
            return this;
        }

        public final Builder q3(double value) {
            this.q3 = value;
            return this;
        }

        public final Builder lower(double value) {
            this.lower = value;
            return this;
        }

        public final Builder upper(double value) {
            this.upper = value;
            return this;
        }

        public final Builder minAsString(@Nullable String value) {
            this.minAsString = value;
            return this;
        }

        public final Builder maxAsString(@Nullable String value) {
            this.maxAsString = value;
            return this;
        }

        public final Builder q1AsString(@Nullable String value) {
            this.q1AsString = value;
            return this;
        }

        public final Builder q2AsString(@Nullable String value) {
            this.q2AsString = value;
            return this;
        }

        public final Builder q3AsString(@Nullable String value) {
            this.q3AsString = value;
            return this;
        }

        public final Builder lowerAsString(@Nullable String value) {
            this.lowerAsString = value;
            return this;
        }

        public final Builder upperAsString(@Nullable String value) {
            this.upperAsString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BoxPlotAggregate build() {
            this._checkSingleUse();
            return new BoxPlotAggregate(this);
        }
    }
}

