/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ccr.UnfollowResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class UnfollowRequest
extends RequestBase {
    private final String index;
    @Nullable
    private final Time masterTimeout;
    public static final Endpoint<UnfollowRequest, UnfollowResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UnfollowRequest, UnfollowResponse>("es/ccr.unfollow", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_ccr");
            buf.append("/unfollow");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("index", request.index);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, UnfollowResponse._DESERIALIZER);

    private UnfollowRequest(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.masterTimeout = builder.masterTimeout;
    }

    public static UnfollowRequest of(Function<Builder, ObjectBuilder<UnfollowRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UnfollowRequest> {
        private String index;
        @Nullable
        private Time masterTimeout;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UnfollowRequest build() {
            this._checkSingleUse();
            return new UnfollowRequest(this);
        }
    }
}

