/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_transform_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TransformProgress
implements JsonpSerializable {
    private final long docsIndexed;
    private final long docsProcessed;
    @Nullable
    private final Long docsRemaining;
    @Nullable
    private final Double percentComplete;
    @Nullable
    private final Long totalDocs;
    public static final JsonpDeserializer<TransformProgress> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TransformProgress::setupTransformProgressDeserializer);

    private TransformProgress(Builder builder) {
        this.docsIndexed = ApiTypeHelper.requireNonNull(builder.docsIndexed, (Object)this, "docsIndexed", 0L);
        this.docsProcessed = ApiTypeHelper.requireNonNull(builder.docsProcessed, (Object)this, "docsProcessed", 0L);
        this.docsRemaining = builder.docsRemaining;
        this.percentComplete = builder.percentComplete;
        this.totalDocs = builder.totalDocs;
    }

    public static TransformProgress of(Function<Builder, ObjectBuilder<TransformProgress>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long docsIndexed() {
        return this.docsIndexed;
    }

    public final long docsProcessed() {
        return this.docsProcessed;
    }

    @Nullable
    public final Long docsRemaining() {
        return this.docsRemaining;
    }

    @Nullable
    public final Double percentComplete() {
        return this.percentComplete;
    }

    @Nullable
    public final Long totalDocs() {
        return this.totalDocs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("docs_indexed");
        generator.write(this.docsIndexed);
        generator.writeKey("docs_processed");
        generator.write(this.docsProcessed);
        if (this.docsRemaining != null) {
            generator.writeKey("docs_remaining");
            generator.write(this.docsRemaining.longValue());
        }
        if (this.percentComplete != null) {
            generator.writeKey("percent_complete");
            generator.write(this.percentComplete.doubleValue());
        }
        if (this.totalDocs != null) {
            generator.writeKey("total_docs");
            generator.write(this.totalDocs.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTransformProgressDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docsIndexed, JsonpDeserializer.longDeserializer(), "docs_indexed");
        op.add(Builder::docsProcessed, JsonpDeserializer.longDeserializer(), "docs_processed");
        op.add(Builder::docsRemaining, JsonpDeserializer.longDeserializer(), "docs_remaining");
        op.add(Builder::percentComplete, JsonpDeserializer.doubleDeserializer(), "percent_complete");
        op.add(Builder::totalDocs, JsonpDeserializer.longDeserializer(), "total_docs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TransformProgress> {
        private Long docsIndexed;
        private Long docsProcessed;
        @Nullable
        private Long docsRemaining;
        @Nullable
        private Double percentComplete;
        @Nullable
        private Long totalDocs;

        public final Builder docsIndexed(long value) {
            this.docsIndexed = value;
            return this;
        }

        public final Builder docsProcessed(long value) {
            this.docsProcessed = value;
            return this;
        }

        public final Builder docsRemaining(@Nullable Long value) {
            this.docsRemaining = value;
            return this;
        }

        public final Builder percentComplete(@Nullable Double value) {
            this.percentComplete = value;
            return this;
        }

        public final Builder totalDocs(@Nullable Long value) {
            this.totalDocs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TransformProgress build() {
            this._checkSingleUse();
            return new TransformProgress(this);
        }
    }
}

