/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.ClusterPrivilege;
import co.elastic.clients.elasticsearch.security.GlobalPrivilege;
import co.elastic.clients.elasticsearch.security.IndicesPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteClusterPrivileges;
import co.elastic.clients.elasticsearch.security.RemoteIndicesPrivileges;
import co.elastic.clients.elasticsearch.security.Restriction;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleDescriptor
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndicesPrivileges> indices;
    private final List<RemoteIndicesPrivileges> remoteIndices;
    private final List<RemoteClusterPrivileges> remoteCluster;
    private final List<GlobalPrivilege> global;
    private final List<ApplicationPrivileges> applications;
    private final Map<String, JsonData> metadata;
    private final List<String> runAs;
    @Nullable
    private final String description;
    @Nullable
    private final Restriction restriction;
    private final Map<String, JsonData> transientMetadata;
    public static final JsonpDeserializer<RoleDescriptor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleDescriptor::setupRoleDescriptorDeserializer);

    protected RoleDescriptor(AbstractBuilder<?> builder) {
        this.cluster = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).cluster);
        this.indices = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).indices);
        this.remoteIndices = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).remoteIndices);
        this.remoteCluster = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).remoteCluster);
        this.global = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).global);
        this.applications = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).applications);
        this.metadata = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).metadata);
        this.runAs = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).runAs);
        this.description = ((AbstractBuilder)builder).description;
        this.restriction = ((AbstractBuilder)builder).restriction;
        this.transientMetadata = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).transientMetadata);
    }

    public static RoleDescriptor roleDescriptorOf(Function<Builder, ObjectBuilder<RoleDescriptor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<IndicesPrivileges> indices() {
        return this.indices;
    }

    public final List<RemoteIndicesPrivileges> remoteIndices() {
        return this.remoteIndices;
    }

    public final List<RemoteClusterPrivileges> remoteCluster() {
        return this.remoteCluster;
    }

    public final List<GlobalPrivilege> global() {
        return this.global;
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final List<String> runAs() {
        return this.runAs;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Restriction restriction() {
        return this.restriction;
    }

    public final Map<String, JsonData> transientMetadata() {
        return this.transientMetadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (IndicesPrivileges indicesPrivileges : this.indices) {
                indicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteIndices)) {
            generator.writeKey("remote_indices");
            generator.writeStartArray();
            for (RemoteIndicesPrivileges remoteIndicesPrivileges : this.remoteIndices) {
                remoteIndicesPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.remoteCluster)) {
            generator.writeKey("remote_cluster");
            generator.writeStartArray();
            for (RemoteClusterPrivileges remoteClusterPrivileges : this.remoteCluster) {
                remoteClusterPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.global)) {
            generator.writeKey("global");
            generator.writeStartArray();
            for (GlobalPrivilege globalPrivilege : this.global) {
                globalPrivilege.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.runAs)) {
            generator.writeKey("run_as");
            generator.writeStartArray();
            for (String string : this.runAs) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.restriction != null) {
            generator.writeKey("restriction");
            this.restriction.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.transientMetadata)) {
            generator.writeKey("transient_metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.transientMetadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupRoleDescriptorDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(AbstractBuilder::indices, JsonpDeserializer.arrayDeserializer(IndicesPrivileges._DESERIALIZER), "indices", "index");
        op.add(AbstractBuilder::remoteIndices, JsonpDeserializer.arrayDeserializer(RemoteIndicesPrivileges._DESERIALIZER), "remote_indices");
        op.add(AbstractBuilder::remoteCluster, JsonpDeserializer.arrayDeserializer(RemoteClusterPrivileges._DESERIALIZER), "remote_cluster");
        op.add(AbstractBuilder::global, JsonpDeserializer.arrayDeserializer(GlobalPrivilege._DESERIALIZER), "global");
        op.add(AbstractBuilder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
        op.add(AbstractBuilder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(AbstractBuilder::runAs, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "run_as");
        op.add(AbstractBuilder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(AbstractBuilder::restriction, Restriction._DESERIALIZER, "restriction");
        op.add(AbstractBuilder::transientMetadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "transient_metadata");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private List<String> cluster;
        @Nullable
        private List<IndicesPrivileges> indices;
        @Nullable
        private List<RemoteIndicesPrivileges> remoteIndices;
        @Nullable
        private List<RemoteClusterPrivileges> remoteCluster;
        @Nullable
        private List<GlobalPrivilege> global;
        @Nullable
        private List<ApplicationPrivileges> applications;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private List<String> runAs;
        @Nullable
        private String description;
        @Nullable
        private Restriction restriction;
        @Nullable
        private Map<String, JsonData> transientMetadata;

        public final BuilderT cluster(List<String> list) {
            this.cluster = AbstractBuilder._listAddAll(this.cluster, list);
            return (BuilderT)this.self();
        }

        public final BuilderT cluster(String value, String ... values) {
            this.cluster = AbstractBuilder._listAdd(this.cluster, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT cluster(ClusterPrivilege value, ClusterPrivilege ... values) {
            this.cluster = AbstractBuilder._listAdd(this.cluster, value.jsonValue(), (String[])Arrays.stream(values).map(ClusterPrivilege::jsonValue).toArray(String[]::new));
            return (BuilderT)this.self();
        }

        public final BuilderT indices(List<IndicesPrivileges> list) {
            this.indices = AbstractBuilder._listAddAll(this.indices, list);
            return (BuilderT)this.self();
        }

        public final BuilderT indices(IndicesPrivileges value, IndicesPrivileges ... values) {
            this.indices = AbstractBuilder._listAdd(this.indices, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT indices(Function<IndicesPrivileges.Builder, ObjectBuilder<IndicesPrivileges>> fn) {
            return this.indices(fn.apply(new IndicesPrivileges.Builder()).build(), new IndicesPrivileges[0]);
        }

        public final BuilderT remoteIndices(List<RemoteIndicesPrivileges> list) {
            this.remoteIndices = AbstractBuilder._listAddAll(this.remoteIndices, list);
            return (BuilderT)this.self();
        }

        public final BuilderT remoteIndices(RemoteIndicesPrivileges value, RemoteIndicesPrivileges ... values) {
            this.remoteIndices = AbstractBuilder._listAdd(this.remoteIndices, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT remoteIndices(Function<RemoteIndicesPrivileges.Builder, ObjectBuilder<RemoteIndicesPrivileges>> fn) {
            return this.remoteIndices(fn.apply(new RemoteIndicesPrivileges.Builder()).build(), new RemoteIndicesPrivileges[0]);
        }

        public final BuilderT remoteCluster(List<RemoteClusterPrivileges> list) {
            this.remoteCluster = AbstractBuilder._listAddAll(this.remoteCluster, list);
            return (BuilderT)this.self();
        }

        public final BuilderT remoteCluster(RemoteClusterPrivileges value, RemoteClusterPrivileges ... values) {
            this.remoteCluster = AbstractBuilder._listAdd(this.remoteCluster, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT remoteCluster(Function<RemoteClusterPrivileges.Builder, ObjectBuilder<RemoteClusterPrivileges>> fn) {
            return this.remoteCluster(fn.apply(new RemoteClusterPrivileges.Builder()).build(), new RemoteClusterPrivileges[0]);
        }

        public final BuilderT global(List<GlobalPrivilege> list) {
            this.global = AbstractBuilder._listAddAll(this.global, list);
            return (BuilderT)this.self();
        }

        public final BuilderT global(GlobalPrivilege value, GlobalPrivilege ... values) {
            this.global = AbstractBuilder._listAdd(this.global, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT global(Function<GlobalPrivilege.Builder, ObjectBuilder<GlobalPrivilege>> fn) {
            return this.global(fn.apply(new GlobalPrivilege.Builder()).build(), new GlobalPrivilege[0]);
        }

        public final BuilderT applications(List<ApplicationPrivileges> list) {
            this.applications = AbstractBuilder._listAddAll(this.applications, list);
            return (BuilderT)this.self();
        }

        public final BuilderT applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = AbstractBuilder._listAdd(this.applications, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        public final BuilderT metadata(Map<String, JsonData> map) {
            this.metadata = AbstractBuilder._mapPutAll(this.metadata, map);
            return (BuilderT)this.self();
        }

        public final BuilderT metadata(String key, JsonData value) {
            this.metadata = AbstractBuilder._mapPut(this.metadata, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT runAs(List<String> list) {
            this.runAs = AbstractBuilder._listAddAll(this.runAs, list);
            return (BuilderT)this.self();
        }

        public final BuilderT runAs(String value, String ... values) {
            this.runAs = AbstractBuilder._listAdd(this.runAs, value, values);
            return (BuilderT)this.self();
        }

        public final BuilderT description(@Nullable String value) {
            this.description = value;
            return (BuilderT)this.self();
        }

        public final BuilderT restriction(@Nullable Restriction value) {
            this.restriction = value;
            return (BuilderT)this.self();
        }

        public final BuilderT restriction(Function<Restriction.Builder, ObjectBuilder<Restriction>> fn) {
            return this.restriction(fn.apply(new Restriction.Builder()).build());
        }

        public final BuilderT transientMetadata(Map<String, JsonData> map) {
            this.transientMetadata = AbstractBuilder._mapPutAll(this.transientMetadata, map);
            return (BuilderT)this.self();
        }

        public final BuilderT transientMetadata(String key, JsonData value) {
            this.transientMetadata = AbstractBuilder._mapPut(this.transientMetadata, key, value);
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<RoleDescriptor> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RoleDescriptor build() {
            this._checkSingleUse();
            return new RoleDescriptor(this);
        }
    }
}

