/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch._types.LifecycleOperationMode;
import co.elastic.clients.elasticsearch.core.health_report.SlmIndicatorUnhealthyPolicies;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlmIndicatorDetails
implements JsonpSerializable {
    private final LifecycleOperationMode slmStatus;
    private final long policies;
    @Nullable
    private final SlmIndicatorUnhealthyPolicies unhealthyPolicies;
    public static final JsonpDeserializer<SlmIndicatorDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlmIndicatorDetails::setupSlmIndicatorDetailsDeserializer);

    private SlmIndicatorDetails(Builder builder) {
        this.slmStatus = ApiTypeHelper.requireNonNull(builder.slmStatus, this, "slmStatus");
        this.policies = ApiTypeHelper.requireNonNull(builder.policies, (Object)this, "policies", 0L);
        this.unhealthyPolicies = builder.unhealthyPolicies;
    }

    public static SlmIndicatorDetails of(Function<Builder, ObjectBuilder<SlmIndicatorDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final LifecycleOperationMode slmStatus() {
        return this.slmStatus;
    }

    public final long policies() {
        return this.policies;
    }

    @Nullable
    public final SlmIndicatorUnhealthyPolicies unhealthyPolicies() {
        return this.unhealthyPolicies;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("slm_status");
        this.slmStatus.serialize(generator, mapper);
        generator.writeKey("policies");
        generator.write(this.policies);
        if (this.unhealthyPolicies != null) {
            generator.writeKey("unhealthy_policies");
            this.unhealthyPolicies.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSlmIndicatorDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::slmStatus, LifecycleOperationMode._DESERIALIZER, "slm_status");
        op.add(Builder::policies, JsonpDeserializer.longDeserializer(), "policies");
        op.add(Builder::unhealthyPolicies, SlmIndicatorUnhealthyPolicies._DESERIALIZER, "unhealthy_policies");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlmIndicatorDetails> {
        private LifecycleOperationMode slmStatus;
        private Long policies;
        @Nullable
        private SlmIndicatorUnhealthyPolicies unhealthyPolicies;

        public final Builder slmStatus(LifecycleOperationMode value) {
            this.slmStatus = value;
            return this;
        }

        public final Builder policies(long value) {
            this.policies = value;
            return this;
        }

        public final Builder unhealthyPolicies(@Nullable SlmIndicatorUnhealthyPolicies value) {
            this.unhealthyPolicies = value;
            return this;
        }

        public final Builder unhealthyPolicies(Function<SlmIndicatorUnhealthyPolicies.Builder, ObjectBuilder<SlmIndicatorUnhealthyPolicies>> fn) {
            return this.unhealthyPolicies(fn.apply(new SlmIndicatorUnhealthyPolicies.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlmIndicatorDetails build() {
            this._checkSingleUse();
            return new SlmIndicatorDetails(this);
        }
    }
}

