/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.InferenceEndpoint;
import co.elastic.clients.elasticsearch.inference.TaskTypeCustom;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;

public abstract class InferenceEndpointInfoCustom
extends InferenceEndpoint {
    private final String inferenceId;
    private final TaskTypeCustom taskType;

    protected InferenceEndpointInfoCustom(AbstractBuilder<?> builder) {
        super(builder);
        this.inferenceId = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).inferenceId, this, "inferenceId");
        this.taskType = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).taskType, this, "taskType");
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    public final TaskTypeCustom taskType() {
        return this.taskType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("inference_id");
        generator.write(this.inferenceId);
        generator.writeKey("task_type");
        this.taskType.serialize(generator, mapper);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupInferenceEndpointInfoCustomDeserializer(ObjectDeserializer<BuilderT> op) {
        InferenceEndpoint.setupInferenceEndpointDeserializer(op);
        op.add(AbstractBuilder::inferenceId, JsonpDeserializer.stringDeserializer(), "inference_id");
        op.add(AbstractBuilder::taskType, TaskTypeCustom._DESERIALIZER, "task_type");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends InferenceEndpoint.AbstractBuilder<BuilderT> {
        private String inferenceId;
        private TaskTypeCustom taskType;

        public final BuilderT inferenceId(String value) {
            this.inferenceId = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT taskType(TaskTypeCustom value) {
            this.taskType = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

