/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DocStats
implements JsonpSerializable {
    private final long count;
    @Nullable
    private final Long deleted;
    private final long totalSizeInBytes;
    @Nullable
    private final String totalSize;
    public static final JsonpDeserializer<DocStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DocStats::setupDocStatsDeserializer);

    private DocStats(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.deleted = builder.deleted;
        this.totalSizeInBytes = ApiTypeHelper.requireNonNull(builder.totalSizeInBytes, (Object)this, "totalSizeInBytes", 0L);
        this.totalSize = builder.totalSize;
    }

    public static DocStats of(Function<Builder, ObjectBuilder<DocStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    @Nullable
    public final Long deleted() {
        return this.deleted;
    }

    public final long totalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    @Nullable
    public final String totalSize() {
        return this.totalSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.deleted != null) {
            generator.writeKey("deleted");
            generator.write(this.deleted.longValue());
        }
        generator.writeKey("total_size_in_bytes");
        generator.write(this.totalSizeInBytes);
        if (this.totalSize != null) {
            generator.writeKey("total_size");
            generator.write(this.totalSize);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDocStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::totalSizeInBytes, JsonpDeserializer.longDeserializer(), "total_size_in_bytes");
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DocStats> {
        private Long count;
        @Nullable
        private Long deleted;
        private Long totalSizeInBytes;
        @Nullable
        private String totalSize;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder deleted(@Nullable Long value) {
            this.deleted = value;
            return this;
        }

        public final Builder totalSizeInBytes(long value) {
            this.totalSizeInBytes = value;
            return this;
        }

        public final Builder totalSize(@Nullable String value) {
            this.totalSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DocStats build() {
            this._checkSingleUse();
            return new DocStats(this);
        }
    }
}

