/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

//----------------------------------------------------------------
//       THIS CODE IS GENERATED. MANUAL EDITS WILL BE LOST.
//----------------------------------------------------------------
//
// This code is generated from the Elasticsearch API specification
// at https://github.com/elastic/elasticsearch-specification
//
// Manual updates to this file will be lost when the code is
// re-generated.
//
// If you find a property that is missing or wrongly typed, please
// open an issue or a PR on the API specification repository.
//
//----------------------------------------------------------------

// typedef: _types.aggregations.GeoHexGridAggregate

/**
 *
 * @see <a href=
 *      "../../doc-files/api-spec.html#_types.aggregations.GeoHexGridAggregate">API
 *      specification</a>
 */
@JsonpDeserializable
public class GeoHexGridAggregate extends MultiBucketAggregateBase<GeoHexGridBucket> implements AggregateVariant {
	// ---------------------------------------------------------------------------------------------

	private GeoHexGridAggregate(Builder builder) {
		super(builder);

	}

	public static GeoHexGridAggregate of(Function<Builder, ObjectBuilder<GeoHexGridAggregate>> fn) {
		return fn.apply(new Builder()).build();
	}

	/**
	 * Aggregate variant kind.
	 */
	@Override
	public Aggregate.Kind _aggregateKind() {
		return Aggregate.Kind.GeohexGrid;
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Builder for {@link GeoHexGridAggregate}.
	 */

	public static class Builder extends MultiBucketAggregateBase.AbstractBuilder<GeoHexGridBucket, Builder>
			implements
				ObjectBuilder<GeoHexGridAggregate> {
		@Override
		protected Builder self() {
			return this;
		}

		/**
		 * Builds a {@link GeoHexGridAggregate}.
		 *
		 * @throws NullPointerException
		 *             if some of the required fields are null.
		 */
		public GeoHexGridAggregate build() {
			_checkSingleUse();
			super.tBucketSerializer(null);

			return new GeoHexGridAggregate(this);
		}
	}

	// ---------------------------------------------------------------------------------------------

	/**
	 * Json deserializer for {@link GeoHexGridAggregate}
	 */
	public static final JsonpDeserializer<GeoHexGridAggregate> _DESERIALIZER = ObjectBuilderDeserializer
			.lazy(Builder::new, GeoHexGridAggregate::setupGeoHexGridAggregateDeserializer);

	protected static void setupGeoHexGridAggregateDeserializer(ObjectDeserializer<GeoHexGridAggregate.Builder> op) {
		MultiBucketAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, GeoHexGridBucket._DESERIALIZER);

	}

}
