/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpackLicense;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpackMl;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoXpackSecurity;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoXpack
implements JsonpSerializable {
    @Nullable
    private final NodeInfoXpackLicense license;
    private final NodeInfoXpackSecurity security;
    private final Map<String, JsonData> notification;
    @Nullable
    private final NodeInfoXpackMl ml;
    public static final JsonpDeserializer<NodeInfoXpack> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoXpack::setupNodeInfoXpackDeserializer);

    private NodeInfoXpack(Builder builder) {
        this.license = builder.license;
        this.security = ApiTypeHelper.requireNonNull(builder.security, this, "security");
        this.notification = ApiTypeHelper.unmodifiable(builder.notification);
        this.ml = builder.ml;
    }

    public static NodeInfoXpack of(Function<Builder, ObjectBuilder<NodeInfoXpack>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final NodeInfoXpackLicense license() {
        return this.license;
    }

    public final NodeInfoXpackSecurity security() {
        return this.security;
    }

    public final Map<String, JsonData> notification() {
        return this.notification;
    }

    @Nullable
    public final NodeInfoXpackMl ml() {
        return this.ml;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.license != null) {
            generator.writeKey("license");
            this.license.serialize(generator, mapper);
        }
        generator.writeKey("security");
        this.security.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.notification)) {
            generator.writeKey("notification");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.notification.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ml != null) {
            generator.writeKey("ml");
            this.ml.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupNodeInfoXpackDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::license, NodeInfoXpackLicense._DESERIALIZER, "license");
        op.add(Builder::security, NodeInfoXpackSecurity._DESERIALIZER, "security");
        op.add(Builder::notification, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "notification");
        op.add(Builder::ml, NodeInfoXpackMl._DESERIALIZER, "ml");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoXpack> {
        @Nullable
        private NodeInfoXpackLicense license;
        private NodeInfoXpackSecurity security;
        @Nullable
        private Map<String, JsonData> notification;
        @Nullable
        private NodeInfoXpackMl ml;

        public final Builder license(@Nullable NodeInfoXpackLicense value) {
            this.license = value;
            return this;
        }

        public final Builder license(Function<NodeInfoXpackLicense.Builder, ObjectBuilder<NodeInfoXpackLicense>> fn) {
            return this.license(fn.apply(new NodeInfoXpackLicense.Builder()).build());
        }

        public final Builder security(NodeInfoXpackSecurity value) {
            this.security = value;
            return this;
        }

        public final Builder security(Function<NodeInfoXpackSecurity.Builder, ObjectBuilder<NodeInfoXpackSecurity>> fn) {
            return this.security(fn.apply(new NodeInfoXpackSecurity.Builder()).build());
        }

        public final Builder notification(Map<String, JsonData> map) {
            this.notification = Builder._mapPutAll(this.notification, map);
            return this;
        }

        public final Builder notification(String key, JsonData value) {
            this.notification = Builder._mapPut(this.notification, key, value);
            return this;
        }

        public final Builder ml(@Nullable NodeInfoXpackMl value) {
            this.ml = value;
            return this;
        }

        public final Builder ml(Function<NodeInfoXpackMl.Builder, ObjectBuilder<NodeInfoXpackMl>> fn) {
            return this.ml(fn.apply(new NodeInfoXpackMl.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoXpack build() {
            this._checkSingleUse();
            return new NodeInfoXpack(this);
        }
    }
}

