/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.watcher.AckWatchResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class AckWatchRequest
extends RequestBase {
    private final List<String> actionId;
    private final String watchId;
    public static final Endpoint<AckWatchRequest, AckWatchResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AckWatchRequest, AckWatchResponse>("es/watcher.ack_watch", request -> "PUT", request -> {
        boolean _watchId = true;
        int _actionId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (ApiTypeHelper.isDefined(request.actionId())) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.watchId, buf);
            buf.append("/_ack");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_watcher");
            buf.append("/watch");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.watchId, buf);
            buf.append("/_ack");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.actionId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _watchId = true;
        int _actionId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (ApiTypeHelper.isDefined(request.actionId())) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            params.put("watchId", request.watchId);
        }
        if (propsSet == 3) {
            params.put("watchId", request.watchId);
            params.put("actionId", request.actionId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, AckWatchResponse._DESERIALIZER);

    private AckWatchRequest(Builder builder) {
        this.actionId = ApiTypeHelper.unmodifiable(builder.actionId);
        this.watchId = ApiTypeHelper.requireNonNull(builder.watchId, this, "watchId");
    }

    public static AckWatchRequest of(Function<Builder, ObjectBuilder<AckWatchRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> actionId() {
        return this.actionId;
    }

    public final String watchId() {
        return this.watchId;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AckWatchRequest> {
        @Nullable
        private List<String> actionId;
        private String watchId;

        public Builder() {
        }

        private Builder(AckWatchRequest instance) {
            this.actionId = instance.actionId;
            this.watchId = instance.watchId;
        }

        public final Builder actionId(List<String> list) {
            this.actionId = Builder._listAddAll(this.actionId, list);
            return this;
        }

        public final Builder actionId(String value, String ... values) {
            this.actionId = Builder._listAdd(this.actionId, value, values);
            return this;
        }

        public final Builder watchId(String value) {
            this.watchId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AckWatchRequest build() {
            this._checkSingleUse();
            return new AckWatchRequest(this);
        }
    }
}

