/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlmConfiguration
implements JsonpSerializable {
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> indices;
    @Nullable
    private final Boolean includeGlobalState;
    private final List<String> featureStates;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Boolean partial;
    public static final JsonpDeserializer<SlmConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlmConfiguration::setupSlmConfigurationDeserializer);

    private SlmConfiguration(Builder builder) {
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.includeGlobalState = builder.includeGlobalState;
        this.featureStates = ApiTypeHelper.unmodifiable(builder.featureStates);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.partial = builder.partial;
    }

    public static SlmConfiguration of(Function<Builder, ObjectBuilder<SlmConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> indices() {
        return this.indices;
    }

    @Nullable
    public final Boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public final List<String> featureStates() {
        return this.featureStates;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Boolean partial() {
        return this.partial;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.includeGlobalState != null) {
            generator.writeKey("include_global_state");
            generator.write(this.includeGlobalState.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.featureStates)) {
            generator.writeKey("feature_states");
            generator.writeStartArray();
            for (String string : this.featureStates) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.partial != null) {
            generator.writeKey("partial");
            generator.write(this.partial.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSlmConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::includeGlobalState, JsonpDeserializer.booleanDeserializer(), "include_global_state");
        op.add(Builder::featureStates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_states");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::partial, JsonpDeserializer.booleanDeserializer(), "partial");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlmConfiguration> {
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> indices;
        @Nullable
        private Boolean includeGlobalState;
        @Nullable
        private List<String> featureStates;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Boolean partial;

        public Builder() {
        }

        private Builder(SlmConfiguration instance) {
            this.ignoreUnavailable = instance.ignoreUnavailable;
            this.indices = instance.indices;
            this.includeGlobalState = instance.includeGlobalState;
            this.featureStates = instance.featureStates;
            this.metadata = instance.metadata;
            this.partial = instance.partial;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder includeGlobalState(@Nullable Boolean value) {
            this.includeGlobalState = value;
            return this;
        }

        public final Builder featureStates(List<String> list) {
            this.featureStates = Builder._listAddAll(this.featureStates, list);
            return this;
        }

        public final Builder featureStates(String value, String ... values) {
            this.featureStates = Builder._listAdd(this.featureStates, value, values);
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder partial(@Nullable Boolean value) {
            this.partial = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlmConfiguration build() {
            this._checkSingleUse();
            return new SlmConfiguration(this);
        }
    }
}

