/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.grant_api_key;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.security.RoleDescriptor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GrantApiKey
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final Time expiration;
    private final List<Map<String, RoleDescriptor>> roleDescriptors;
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<GrantApiKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GrantApiKey::setupGrantApiKeyDeserializer);

    private GrantApiKey(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.expiration = builder.expiration;
        this.roleDescriptors = ApiTypeHelper.unmodifiable(builder.roleDescriptors);
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
    }

    public static GrantApiKey of(Function<Builder, ObjectBuilder<GrantApiKey>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final Time expiration() {
        return this.expiration;
    }

    public final List<Map<String, RoleDescriptor>> roleDescriptors() {
        return this.roleDescriptors;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            this.expiration.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.roleDescriptors)) {
            generator.writeKey("role_descriptors");
            generator.writeStartArray();
            for (Map<String, RoleDescriptor> map : this.roleDescriptors) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry<String, RoleDescriptor> item1 : map.entrySet()) {
                        generator.writeKey(item1.getKey());
                        item1.getValue().serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry entry : this.metadata.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGrantApiKeyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::expiration, Time._DESERIALIZER, "expiration");
        op.add(Builder::roleDescriptors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(RoleDescriptor._DESERIALIZER)), "role_descriptors");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GrantApiKey> {
        private String name;
        @Nullable
        private Time expiration;
        @Nullable
        private List<Map<String, RoleDescriptor>> roleDescriptors;
        @Nullable
        private Map<String, JsonData> metadata;

        public Builder() {
        }

        private Builder(GrantApiKey instance) {
            this.name = instance.name;
            this.expiration = instance.expiration;
            this.roleDescriptors = instance.roleDescriptors;
            this.metadata = instance.metadata;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder expiration(@Nullable Time value) {
            this.expiration = value;
            return this;
        }

        public final Builder expiration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiration(fn.apply(new Time.Builder()).build());
        }

        public final Builder roleDescriptors(List<Map<String, RoleDescriptor>> list) {
            this.roleDescriptors = Builder._listAddAll(this.roleDescriptors, list);
            return this;
        }

        public final Builder roleDescriptors(Map<String, RoleDescriptor> value, Map<String, RoleDescriptor> ... values) {
            this.roleDescriptors = Builder._listAdd(this.roleDescriptors, value, values);
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GrantApiKey build() {
            this._checkSingleUse();
            return new GrantApiKey(this);
        }
    }
}

