/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.DisableUserResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DisableUserRequest
extends RequestBase {
    @Nullable
    private final Refresh refresh;
    private final String username;
    public static final Endpoint<DisableUserRequest, DisableUserResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DisableUserRequest, DisableUserResponse>("es/security.disable_user", request -> "PUT", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            buf.append("/_disable");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _username = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("username", request.username);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DisableUserResponse._DESERIALIZER);

    private DisableUserRequest(Builder builder) {
        this.refresh = builder.refresh;
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
    }

    public static DisableUserRequest of(Function<Builder, ObjectBuilder<DisableUserRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final String username() {
        return this.username;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DisableUserRequest> {
        @Nullable
        private Refresh refresh;
        private String username;

        public Builder() {
        }

        private Builder(DisableUserRequest instance) {
            this.refresh = instance.refresh;
            this.username = instance.username;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DisableUserRequest build() {
            this._checkSingleUse();
            return new DisableUserRequest(this);
        }
    }
}

