/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.rollup.FieldMetric;
import co.elastic.clients.elasticsearch.rollup.Groupings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RollupJobConfiguration
implements JsonpSerializable {
    private final String cron;
    private final Groupings groups;
    private final String id;
    private final String indexPattern;
    private final List<FieldMetric> metrics;
    private final long pageSize;
    private final String rollupIndex;
    private final Time timeout;
    public static final JsonpDeserializer<RollupJobConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobConfiguration::setupRollupJobConfigurationDeserializer);

    private RollupJobConfiguration(Builder builder) {
        this.cron = ApiTypeHelper.requireNonNull(builder.cron, this, "cron");
        this.groups = ApiTypeHelper.requireNonNull(builder.groups, this, "groups");
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.indexPattern = ApiTypeHelper.requireNonNull(builder.indexPattern, this, "indexPattern");
        this.metrics = ApiTypeHelper.unmodifiableRequired(builder.metrics, (Object)this, "metrics");
        this.pageSize = ApiTypeHelper.requireNonNull(builder.pageSize, (Object)this, "pageSize", 0L);
        this.rollupIndex = ApiTypeHelper.requireNonNull(builder.rollupIndex, this, "rollupIndex");
        this.timeout = ApiTypeHelper.requireNonNull(builder.timeout, this, "timeout");
    }

    public static RollupJobConfiguration of(Function<Builder, ObjectBuilder<RollupJobConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String cron() {
        return this.cron;
    }

    public final Groupings groups() {
        return this.groups;
    }

    public final String id() {
        return this.id;
    }

    public final String indexPattern() {
        return this.indexPattern;
    }

    public final List<FieldMetric> metrics() {
        return this.metrics;
    }

    public final long pageSize() {
        return this.pageSize;
    }

    public final String rollupIndex() {
        return this.rollupIndex;
    }

    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cron");
        generator.write(this.cron);
        generator.writeKey("groups");
        this.groups.serialize(generator, mapper);
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("index_pattern");
        generator.write(this.indexPattern);
        if (ApiTypeHelper.isDefined(this.metrics)) {
            generator.writeKey("metrics");
            generator.writeStartArray();
            for (FieldMetric item0 : this.metrics) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("page_size");
        generator.write(this.pageSize);
        generator.writeKey("rollup_index");
        generator.write(this.rollupIndex);
        generator.writeKey("timeout");
        this.timeout.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRollupJobConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cron, JsonpDeserializer.stringDeserializer(), "cron");
        op.add(Builder::groups, Groupings._DESERIALIZER, "groups");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::indexPattern, JsonpDeserializer.stringDeserializer(), "index_pattern");
        op.add(Builder::metrics, JsonpDeserializer.arrayDeserializer(FieldMetric._DESERIALIZER), "metrics");
        op.add(Builder::pageSize, JsonpDeserializer.longDeserializer(), "page_size");
        op.add(Builder::rollupIndex, JsonpDeserializer.stringDeserializer(), "rollup_index");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RollupJobConfiguration> {
        private String cron;
        private Groupings groups;
        private String id;
        private String indexPattern;
        private List<FieldMetric> metrics;
        private Long pageSize;
        private String rollupIndex;
        private Time timeout;

        public Builder() {
        }

        private Builder(RollupJobConfiguration instance) {
            this.cron = instance.cron;
            this.groups = instance.groups;
            this.id = instance.id;
            this.indexPattern = instance.indexPattern;
            this.metrics = instance.metrics;
            this.pageSize = instance.pageSize;
            this.rollupIndex = instance.rollupIndex;
            this.timeout = instance.timeout;
        }

        public final Builder cron(String value) {
            this.cron = value;
            return this;
        }

        public final Builder groups(Groupings value) {
            this.groups = value;
            return this;
        }

        public final Builder groups(Function<Groupings.Builder, ObjectBuilder<Groupings>> fn) {
            return this.groups(fn.apply(new Groupings.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder indexPattern(String value) {
            this.indexPattern = value;
            return this;
        }

        public final Builder metrics(List<FieldMetric> list) {
            this.metrics = Builder._listAddAll(this.metrics, list);
            return this;
        }

        public final Builder metrics(FieldMetric value, FieldMetric ... values) {
            this.metrics = Builder._listAdd(this.metrics, value, values);
            return this;
        }

        public final Builder metrics(Function<FieldMetric.Builder, ObjectBuilder<FieldMetric>> fn) {
            return this.metrics(fn.apply(new FieldMetric.Builder()).build(), new FieldMetric[0]);
        }

        public final Builder pageSize(long value) {
            this.pageSize = value;
            return this;
        }

        public final Builder rollupIndex(String value) {
            this.rollupIndex = value;
            return this;
        }

        public final Builder timeout(Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RollupJobConfiguration build() {
            this._checkSingleUse();
            return new RollupJobConfiguration(this);
        }
    }
}

