/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.query_rules.list_rulesets;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class QueryRulesetListItem
implements JsonpSerializable {
    private final String rulesetId;
    private final int ruleTotalCount;
    private final Map<String, Integer> ruleCriteriaTypesCounts;
    private final Map<String, Integer> ruleTypeCounts;
    public static final JsonpDeserializer<QueryRulesetListItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRulesetListItem::setupQueryRulesetListItemDeserializer);

    private QueryRulesetListItem(Builder builder) {
        this.rulesetId = ApiTypeHelper.requireNonNull(builder.rulesetId, this, "rulesetId");
        this.ruleTotalCount = ApiTypeHelper.requireNonNull(builder.ruleTotalCount, (Object)this, "ruleTotalCount", 0);
        this.ruleCriteriaTypesCounts = ApiTypeHelper.unmodifiableRequired(builder.ruleCriteriaTypesCounts, (Object)this, "ruleCriteriaTypesCounts");
        this.ruleTypeCounts = ApiTypeHelper.unmodifiableRequired(builder.ruleTypeCounts, (Object)this, "ruleTypeCounts");
    }

    public static QueryRulesetListItem of(Function<Builder, ObjectBuilder<QueryRulesetListItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String rulesetId() {
        return this.rulesetId;
    }

    public final int ruleTotalCount() {
        return this.ruleTotalCount;
    }

    public final Map<String, Integer> ruleCriteriaTypesCounts() {
        return this.ruleCriteriaTypesCounts;
    }

    public final Map<String, Integer> ruleTypeCounts() {
        return this.ruleTypeCounts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("ruleset_id");
        generator.write(this.rulesetId);
        generator.writeKey("rule_total_count");
        generator.write(this.ruleTotalCount);
        if (ApiTypeHelper.isDefined(this.ruleCriteriaTypesCounts)) {
            generator.writeKey("rule_criteria_types_counts");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.ruleCriteriaTypesCounts.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.ruleTypeCounts)) {
            generator.writeKey("rule_type_counts");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> item0 : this.ruleTypeCounts.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().intValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupQueryRulesetListItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rulesetId, JsonpDeserializer.stringDeserializer(), "ruleset_id");
        op.add(Builder::ruleTotalCount, JsonpDeserializer.integerDeserializer(), "rule_total_count");
        op.add(Builder::ruleCriteriaTypesCounts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "rule_criteria_types_counts");
        op.add(Builder::ruleTypeCounts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "rule_type_counts");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRulesetListItem> {
        private String rulesetId;
        private Integer ruleTotalCount;
        private Map<String, Integer> ruleCriteriaTypesCounts;
        private Map<String, Integer> ruleTypeCounts;

        public Builder() {
        }

        private Builder(QueryRulesetListItem instance) {
            this.rulesetId = instance.rulesetId;
            this.ruleTotalCount = instance.ruleTotalCount;
            this.ruleCriteriaTypesCounts = instance.ruleCriteriaTypesCounts;
            this.ruleTypeCounts = instance.ruleTypeCounts;
        }

        public final Builder rulesetId(String value) {
            this.rulesetId = value;
            return this;
        }

        public final Builder ruleTotalCount(int value) {
            this.ruleTotalCount = value;
            return this;
        }

        public final Builder ruleCriteriaTypesCounts(Map<String, Integer> map) {
            this.ruleCriteriaTypesCounts = Builder._mapPutAll(this.ruleCriteriaTypesCounts, map);
            return this;
        }

        public final Builder ruleCriteriaTypesCounts(String key, Integer value) {
            this.ruleCriteriaTypesCounts = Builder._mapPut(this.ruleCriteriaTypesCounts, key, value);
            return this;
        }

        public final Builder ruleTypeCounts(Map<String, Integer> map) {
            this.ruleTypeCounts = Builder._mapPutAll(this.ruleTypeCounts, map);
            return this;
        }

        public final Builder ruleTypeCounts(String key, Integer value) {
            this.ruleTypeCounts = Builder._mapPut(this.ruleTypeCounts, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRulesetListItem build() {
            this._checkSingleUse();
            return new QueryRulesetListItem(this);
        }
    }
}

