/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelResponse;
import co.elastic.clients.elasticsearch.ml.TrainedModelPrefixStrings;
import co.elastic.clients.elasticsearch.ml.TrainedModelType;
import co.elastic.clients.elasticsearch.ml.put_trained_model.Definition;
import co.elastic.clients.elasticsearch.ml.put_trained_model.Input;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutTrainedModelRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String compressedDefinition;
    @Nullable
    private final Boolean deferDefinitionDecompression;
    @Nullable
    private final Definition definition;
    @Nullable
    private final String description;
    @Nullable
    private final InferenceConfigCreate inferenceConfig;
    @Nullable
    private final Input input;
    @Nullable
    private final JsonData metadata;
    private final String modelId;
    @Nullable
    private final Long modelSizeBytes;
    @Nullable
    private final TrainedModelType modelType;
    @Nullable
    private final String platformArchitecture;
    @Nullable
    private final TrainedModelPrefixStrings prefixStrings;
    private final List<String> tags;
    @Nullable
    private final Boolean waitForCompletion;
    public static final JsonpDeserializer<PutTrainedModelRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutTrainedModelRequest::setupPutTrainedModelRequestDeserializer);
    public static final Endpoint<PutTrainedModelRequest, PutTrainedModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutTrainedModelRequest, PutTrainedModelResponse>("es/ml.put_trained_model", request -> "PUT", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.deferDefinitionDecompression != null) {
            params.put("defer_definition_decompression", String.valueOf(request.deferDefinitionDecompression));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutTrainedModelResponse._DESERIALIZER);

    private PutTrainedModelRequest(Builder builder) {
        this.compressedDefinition = builder.compressedDefinition;
        this.deferDefinitionDecompression = builder.deferDefinitionDecompression;
        this.definition = builder.definition;
        this.description = builder.description;
        this.inferenceConfig = builder.inferenceConfig;
        this.input = builder.input;
        this.metadata = builder.metadata;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.modelSizeBytes = builder.modelSizeBytes;
        this.modelType = builder.modelType;
        this.platformArchitecture = builder.platformArchitecture;
        this.prefixStrings = builder.prefixStrings;
        this.tags = ApiTypeHelper.unmodifiable(builder.tags);
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static PutTrainedModelRequest of(Function<Builder, ObjectBuilder<PutTrainedModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String compressedDefinition() {
        return this.compressedDefinition;
    }

    @Nullable
    public final Boolean deferDefinitionDecompression() {
        return this.deferDefinitionDecompression;
    }

    @Nullable
    public final Definition definition() {
        return this.definition;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final InferenceConfigCreate inferenceConfig() {
        return this.inferenceConfig;
    }

    @Nullable
    public final Input input() {
        return this.input;
    }

    @Nullable
    public final JsonData metadata() {
        return this.metadata;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Long modelSizeBytes() {
        return this.modelSizeBytes;
    }

    @Nullable
    public final TrainedModelType modelType() {
        return this.modelType;
    }

    @Nullable
    public final String platformArchitecture() {
        return this.platformArchitecture;
    }

    @Nullable
    public final TrainedModelPrefixStrings prefixStrings() {
        return this.prefixStrings;
    }

    public final List<String> tags() {
        return this.tags;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.compressedDefinition != null) {
            generator.writeKey("compressed_definition");
            generator.write(this.compressedDefinition);
        }
        if (this.definition != null) {
            generator.writeKey("definition");
            this.definition.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
        if (this.input != null) {
            generator.writeKey("input");
            this.input.serialize(generator, mapper);
        }
        if (this.metadata != null) {
            generator.writeKey("metadata");
            this.metadata.serialize(generator, mapper);
        }
        if (this.modelSizeBytes != null) {
            generator.writeKey("model_size_bytes");
            generator.write(this.modelSizeBytes.longValue());
        }
        if (this.modelType != null) {
            generator.writeKey("model_type");
            this.modelType.serialize(generator, mapper);
        }
        if (this.platformArchitecture != null) {
            generator.writeKey("platform_architecture");
            generator.write(this.platformArchitecture);
        }
        if (this.prefixStrings != null) {
            generator.writeKey("prefix_strings");
            this.prefixStrings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.tags)) {
            generator.writeKey("tags");
            generator.writeStartArray();
            for (String item0 : this.tags) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutTrainedModelRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::compressedDefinition, JsonpDeserializer.stringDeserializer(), "compressed_definition");
        op.add(Builder::definition, Definition._DESERIALIZER, "definition");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::inferenceConfig, InferenceConfigCreate._DESERIALIZER, "inference_config");
        op.add(Builder::input, Input._DESERIALIZER, "input");
        op.add(Builder::metadata, JsonData._DESERIALIZER, "metadata");
        op.add(Builder::modelSizeBytes, JsonpDeserializer.longDeserializer(), "model_size_bytes");
        op.add(Builder::modelType, TrainedModelType._DESERIALIZER, "model_type");
        op.add(Builder::platformArchitecture, JsonpDeserializer.stringDeserializer(), "platform_architecture");
        op.add(Builder::prefixStrings, TrainedModelPrefixStrings._DESERIALIZER, "prefix_strings");
        op.add(Builder::tags, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "tags");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutTrainedModelRequest> {
        @Nullable
        private String compressedDefinition;
        @Nullable
        private Boolean deferDefinitionDecompression;
        @Nullable
        private Definition definition;
        @Nullable
        private String description;
        @Nullable
        private InferenceConfigCreate inferenceConfig;
        @Nullable
        private Input input;
        @Nullable
        private JsonData metadata;
        private String modelId;
        @Nullable
        private Long modelSizeBytes;
        @Nullable
        private TrainedModelType modelType;
        @Nullable
        private String platformArchitecture;
        @Nullable
        private TrainedModelPrefixStrings prefixStrings;
        @Nullable
        private List<String> tags;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(PutTrainedModelRequest instance) {
            this.compressedDefinition = instance.compressedDefinition;
            this.deferDefinitionDecompression = instance.deferDefinitionDecompression;
            this.definition = instance.definition;
            this.description = instance.description;
            this.inferenceConfig = instance.inferenceConfig;
            this.input = instance.input;
            this.metadata = instance.metadata;
            this.modelId = instance.modelId;
            this.modelSizeBytes = instance.modelSizeBytes;
            this.modelType = instance.modelType;
            this.platformArchitecture = instance.platformArchitecture;
            this.prefixStrings = instance.prefixStrings;
            this.tags = instance.tags;
            this.waitForCompletion = instance.waitForCompletion;
        }

        public final Builder compressedDefinition(@Nullable String value) {
            this.compressedDefinition = value;
            return this;
        }

        public final Builder deferDefinitionDecompression(@Nullable Boolean value) {
            this.deferDefinitionDecompression = value;
            return this;
        }

        public final Builder definition(@Nullable Definition value) {
            this.definition = value;
            return this;
        }

        public final Builder definition(Function<Definition.Builder, ObjectBuilder<Definition>> fn) {
            return this.definition(fn.apply(new Definition.Builder()).build());
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder inferenceConfig(@Nullable InferenceConfigCreate value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceConfigCreate.Builder, ObjectBuilder<InferenceConfigCreate>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfigCreate.Builder()).build());
        }

        public final Builder inferenceConfig(InferenceConfigCreateVariant value) {
            this.inferenceConfig = value._toInferenceConfigCreate();
            return this;
        }

        public final Builder input(@Nullable Input value) {
            this.input = value;
            return this;
        }

        public final Builder input(Function<Input.Builder, ObjectBuilder<Input>> fn) {
            return this.input(fn.apply(new Input.Builder()).build());
        }

        public final Builder metadata(@Nullable JsonData value) {
            this.metadata = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder modelSizeBytes(@Nullable Long value) {
            this.modelSizeBytes = value;
            return this;
        }

        public final Builder modelType(@Nullable TrainedModelType value) {
            this.modelType = value;
            return this;
        }

        public final Builder platformArchitecture(@Nullable String value) {
            this.platformArchitecture = value;
            return this;
        }

        public final Builder prefixStrings(@Nullable TrainedModelPrefixStrings value) {
            this.prefixStrings = value;
            return this;
        }

        public final Builder prefixStrings(Function<TrainedModelPrefixStrings.Builder, ObjectBuilder<TrainedModelPrefixStrings>> fn) {
            return this.prefixStrings(fn.apply(new TrainedModelPrefixStrings.Builder()).build());
        }

        public final Builder tags(List<String> list) {
            this.tags = Builder._listAddAll(this.tags, list);
            return this;
        }

        public final Builder tags(String value, String ... values) {
            this.tags = Builder._listAdd(this.tags, value, values);
            return this;
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutTrainedModelRequest build() {
            this._checkSingleUse();
            return new PutTrainedModelRequest(this);
        }
    }
}

