/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.DeleteExpiredDataResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DeleteExpiredDataRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String jobId;
    @Nullable
    private final Float requestsPerSecond;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<DeleteExpiredDataRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DeleteExpiredDataRequest::setupDeleteExpiredDataRequestDeserializer);
    public static final Endpoint<DeleteExpiredDataRequest, DeleteExpiredDataResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteExpiredDataRequest, DeleteExpiredDataResponse>("es/ml.delete_expired_data", request -> "DELETE", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/_delete_expired_data");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/_delete_expired_data");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("jobId", request.jobId);
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, DeleteExpiredDataResponse._DESERIALIZER);

    private DeleteExpiredDataRequest(Builder builder) {
        this.jobId = builder.jobId;
        this.requestsPerSecond = builder.requestsPerSecond;
        this.timeout = builder.timeout;
    }

    public static DeleteExpiredDataRequest of(Function<Builder, ObjectBuilder<DeleteExpiredDataRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.requestsPerSecond != null) {
            generator.writeKey("requests_per_second");
            generator.write((double)this.requestsPerSecond.floatValue());
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDeleteExpiredDataRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteExpiredDataRequest> {
        @Nullable
        private String jobId;
        @Nullable
        private Float requestsPerSecond;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(DeleteExpiredDataRequest instance) {
            this.jobId = instance.jobId;
            this.requestsPerSecond = instance.requestsPerSecond;
            this.timeout = instance.timeout;
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        public final Builder requestsPerSecond(@Nullable Float value) {
            this.requestsPerSecond = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteExpiredDataRequest build() {
            this._checkSingleUse();
            return new DeleteExpiredDataRequest(this);
        }
    }
}

