/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeEvaluation;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationClassificationMetrics;
import co.elastic.clients.elasticsearch.ml.DataframeEvaluationVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeEvaluationClassification
implements DataframeEvaluationVariant,
JsonpSerializable {
    private final String actualField;
    @Nullable
    private final String predictedField;
    @Nullable
    private final String topClassesField;
    @Nullable
    private final DataframeEvaluationClassificationMetrics metrics;
    public static final JsonpDeserializer<DataframeEvaluationClassification> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeEvaluationClassification::setupDataframeEvaluationClassificationDeserializer);

    private DataframeEvaluationClassification(Builder builder) {
        this.actualField = ApiTypeHelper.requireNonNull(builder.actualField, this, "actualField");
        this.predictedField = builder.predictedField;
        this.topClassesField = builder.topClassesField;
        this.metrics = builder.metrics;
    }

    public static DataframeEvaluationClassification of(Function<Builder, ObjectBuilder<DataframeEvaluationClassification>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeEvaluation.Kind _dataframeEvaluationKind() {
        return DataframeEvaluation.Kind.Classification;
    }

    public final String actualField() {
        return this.actualField;
    }

    @Nullable
    public final String predictedField() {
        return this.predictedField;
    }

    @Nullable
    public final String topClassesField() {
        return this.topClassesField;
    }

    @Nullable
    public final DataframeEvaluationClassificationMetrics metrics() {
        return this.metrics;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual_field");
        generator.write(this.actualField);
        if (this.predictedField != null) {
            generator.writeKey("predicted_field");
            generator.write(this.predictedField);
        }
        if (this.topClassesField != null) {
            generator.writeKey("top_classes_field");
            generator.write(this.topClassesField);
        }
        if (this.metrics != null) {
            generator.writeKey("metrics");
            this.metrics.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataframeEvaluationClassificationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actualField, JsonpDeserializer.stringDeserializer(), "actual_field");
        op.add(Builder::predictedField, JsonpDeserializer.stringDeserializer(), "predicted_field");
        op.add(Builder::topClassesField, JsonpDeserializer.stringDeserializer(), "top_classes_field");
        op.add(Builder::metrics, DataframeEvaluationClassificationMetrics._DESERIALIZER, "metrics");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeEvaluationClassification> {
        private String actualField;
        @Nullable
        private String predictedField;
        @Nullable
        private String topClassesField;
        @Nullable
        private DataframeEvaluationClassificationMetrics metrics;

        public Builder() {
        }

        private Builder(DataframeEvaluationClassification instance) {
            this.actualField = instance.actualField;
            this.predictedField = instance.predictedField;
            this.topClassesField = instance.topClassesField;
            this.metrics = instance.metrics;
        }

        public final Builder actualField(String value) {
            this.actualField = value;
            return this;
        }

        public final Builder predictedField(@Nullable String value) {
            this.predictedField = value;
            return this;
        }

        public final Builder topClassesField(@Nullable String value) {
            this.topClassesField = value;
            return this;
        }

        public final Builder metrics(@Nullable DataframeEvaluationClassificationMetrics value) {
            this.metrics = value;
            return this;
        }

        public final Builder metrics(Function<DataframeEvaluationClassificationMetrics.Builder, ObjectBuilder<DataframeEvaluationClassificationMetrics>> fn) {
            return this.metrics(fn.apply(new DataframeEvaluationClassificationMetrics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeEvaluationClassification build() {
            this._checkSingleUse();
            return new DataframeEvaluationClassification(this);
        }
    }
}

