/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.migration.post_feature_upgrade;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MigrationFeature
implements JsonpSerializable {
    private final String featureName;
    public static final JsonpDeserializer<MigrationFeature> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MigrationFeature::setupMigrationFeatureDeserializer);

    private MigrationFeature(Builder builder) {
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
    }

    public static MigrationFeature of(Function<Builder, ObjectBuilder<MigrationFeature>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String featureName() {
        return this.featureName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMigrationFeatureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MigrationFeature> {
        private String featureName;

        public Builder() {
        }

        private Builder(MigrationFeature instance) {
            this.featureName = instance.featureName;
        }

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MigrationFeature build() {
            this._checkSingleUse();
            return new MigrationFeature(this);
        }
    }
}

