/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.logstash;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class PipelineSettings
implements JsonpSerializable {
    private final int pipelineWorkers;
    private final int pipelineBatchSize;
    private final int pipelineBatchDelay;
    private final String queueType;
    private final String queueMaxBytes;
    private final int queueCheckpointWrites;
    public static final JsonpDeserializer<PipelineSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineSettings::setupPipelineSettingsDeserializer);

    private PipelineSettings(Builder builder) {
        this.pipelineWorkers = ApiTypeHelper.requireNonNull(builder.pipelineWorkers, (Object)this, "pipelineWorkers", 0);
        this.pipelineBatchSize = ApiTypeHelper.requireNonNull(builder.pipelineBatchSize, (Object)this, "pipelineBatchSize", 0);
        this.pipelineBatchDelay = ApiTypeHelper.requireNonNull(builder.pipelineBatchDelay, (Object)this, "pipelineBatchDelay", 0);
        this.queueType = ApiTypeHelper.requireNonNull(builder.queueType, this, "queueType");
        this.queueMaxBytes = ApiTypeHelper.requireNonNull(builder.queueMaxBytes, this, "queueMaxBytes");
        this.queueCheckpointWrites = ApiTypeHelper.requireNonNull(builder.queueCheckpointWrites, (Object)this, "queueCheckpointWrites", 0);
    }

    public static PipelineSettings of(Function<Builder, ObjectBuilder<PipelineSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int pipelineWorkers() {
        return this.pipelineWorkers;
    }

    public final int pipelineBatchSize() {
        return this.pipelineBatchSize;
    }

    public final int pipelineBatchDelay() {
        return this.pipelineBatchDelay;
    }

    public final String queueType() {
        return this.queueType;
    }

    public final String queueMaxBytes() {
        return this.queueMaxBytes;
    }

    public final int queueCheckpointWrites() {
        return this.queueCheckpointWrites;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("pipeline.workers");
        generator.write(this.pipelineWorkers);
        generator.writeKey("pipeline.batch.size");
        generator.write(this.pipelineBatchSize);
        generator.writeKey("pipeline.batch.delay");
        generator.write(this.pipelineBatchDelay);
        generator.writeKey("queue.type");
        generator.write(this.queueType);
        generator.writeKey("queue.max_bytes");
        generator.write(this.queueMaxBytes);
        generator.writeKey("queue.checkpoint.writes");
        generator.write(this.queueCheckpointWrites);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPipelineSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::pipelineWorkers, JsonpDeserializer.integerDeserializer(), "pipeline.workers");
        op.add(Builder::pipelineBatchSize, JsonpDeserializer.integerDeserializer(), "pipeline.batch.size");
        op.add(Builder::pipelineBatchDelay, JsonpDeserializer.integerDeserializer(), "pipeline.batch.delay");
        op.add(Builder::queueType, JsonpDeserializer.stringDeserializer(), "queue.type");
        op.add(Builder::queueMaxBytes, JsonpDeserializer.stringDeserializer(), "queue.max_bytes");
        op.add(Builder::queueCheckpointWrites, JsonpDeserializer.integerDeserializer(), "queue.checkpoint.writes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PipelineSettings> {
        private Integer pipelineWorkers;
        private Integer pipelineBatchSize;
        private Integer pipelineBatchDelay;
        private String queueType;
        private String queueMaxBytes;
        private Integer queueCheckpointWrites;

        public Builder() {
        }

        private Builder(PipelineSettings instance) {
            this.pipelineWorkers = instance.pipelineWorkers;
            this.pipelineBatchSize = instance.pipelineBatchSize;
            this.pipelineBatchDelay = instance.pipelineBatchDelay;
            this.queueType = instance.queueType;
            this.queueMaxBytes = instance.queueMaxBytes;
            this.queueCheckpointWrites = instance.queueCheckpointWrites;
        }

        public final Builder pipelineWorkers(int value) {
            this.pipelineWorkers = value;
            return this;
        }

        public final Builder pipelineBatchSize(int value) {
            this.pipelineBatchSize = value;
            return this;
        }

        public final Builder pipelineBatchDelay(int value) {
            this.pipelineBatchDelay = value;
            return this;
        }

        public final Builder queueType(String value) {
            this.queueType = value;
            return this;
        }

        public final Builder queueMaxBytes(String value) {
            this.queueMaxBytes = value;
            return this;
        }

        public final Builder queueCheckpointWrites(int value) {
            this.queueCheckpointWrites = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PipelineSettings build() {
            this._checkSingleUse();
            return new PipelineSettings(this);
        }
    }
}

