/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SortProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final SortOrder order;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<SortProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SortProcessor::setupSortProcessorDeserializer);

    private SortProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.order = builder.order;
        this.targetField = builder.targetField;
    }

    public static SortProcessor of(Function<Builder, ObjectBuilder<SortProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Sort;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSortProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SortProcessor> {
        private String field;
        @Nullable
        private SortOrder order;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(SortProcessor instance) {
            this.field = instance.field;
            this.order = instance.order;
            this.targetField = instance.targetField;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SortProcessor build() {
            this._checkSingleUse();
            return new SortProcessor(this);
        }
    }
}

