/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OpenAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final String user;
    public static final JsonpDeserializer<OpenAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OpenAITaskSettings::setupOpenAITaskSettingsDeserializer);

    private OpenAITaskSettings(Builder builder) {
        this.user = builder.user;
    }

    public static OpenAITaskSettings of(Function<Builder, ObjectBuilder<OpenAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String user() {
        return this.user;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.user != null) {
            generator.writeKey("user");
            generator.write(this.user);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupOpenAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::user, JsonpDeserializer.stringDeserializer(), "user");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OpenAITaskSettings> {
        @Nullable
        private String user;

        public Builder() {
        }

        private Builder(OpenAITaskSettings instance) {
            this.user = instance.user;
        }

        public final Builder user(@Nullable String value) {
            this.user = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OpenAITaskSettings build() {
            this._checkSingleUse();
            return new OpenAITaskSettings(this);
        }
    }
}

