/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MistralServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    @Nullable
    private final Integer maxInputTokens;
    private final String model;
    @Nullable
    private final RateLimitSetting rateLimit;
    public static final JsonpDeserializer<MistralServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MistralServiceSettings::setupMistralServiceSettingsDeserializer);

    private MistralServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.maxInputTokens = builder.maxInputTokens;
        this.model = ApiTypeHelper.requireNonNull(builder.model, this, "model");
        this.rateLimit = builder.rateLimit;
    }

    public static MistralServiceSettings of(Function<Builder, ObjectBuilder<MistralServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final Integer maxInputTokens() {
        return this.maxInputTokens;
    }

    public final String model() {
        return this.model;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        if (this.maxInputTokens != null) {
            generator.writeKey("max_input_tokens");
            generator.write(this.maxInputTokens.intValue());
        }
        generator.writeKey("model");
        generator.write(this.model);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMistralServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::maxInputTokens, JsonpDeserializer.integerDeserializer(), "max_input_tokens");
        op.add(Builder::model, JsonpDeserializer.stringDeserializer(), "model");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MistralServiceSettings> {
        private String apiKey;
        @Nullable
        private Integer maxInputTokens;
        private String model;
        @Nullable
        private RateLimitSetting rateLimit;

        public Builder() {
        }

        private Builder(MistralServiceSettings instance) {
            this.apiKey = instance.apiKey;
            this.maxInputTokens = instance.maxInputTokens;
            this.model = instance.model;
            this.rateLimit = instance.rateLimit;
        }

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder maxInputTokens(@Nullable Integer value) {
            this.maxInputTokens = value;
            return this;
        }

        public final Builder model(String value) {
            this.model = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MistralServiceSettings build() {
            this._checkSingleUse();
            return new MistralServiceSettings(this);
        }
    }
}

