/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AzureAiStudioServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String endpointType;
    private final String target;
    private final String provider;
    @Nullable
    private final RateLimitSetting rateLimit;
    public static final JsonpDeserializer<AzureAiStudioServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AzureAiStudioServiceSettings::setupAzureAiStudioServiceSettingsDeserializer);

    private AzureAiStudioServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.endpointType = ApiTypeHelper.requireNonNull(builder.endpointType, this, "endpointType");
        this.target = ApiTypeHelper.requireNonNull(builder.target, this, "target");
        this.provider = ApiTypeHelper.requireNonNull(builder.provider, this, "provider");
        this.rateLimit = builder.rateLimit;
    }

    public static AzureAiStudioServiceSettings of(Function<Builder, ObjectBuilder<AzureAiStudioServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String endpointType() {
        return this.endpointType;
    }

    public final String target() {
        return this.target;
    }

    public final String provider() {
        return this.provider;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("endpoint_type");
        generator.write(this.endpointType);
        generator.writeKey("target");
        generator.write(this.target);
        generator.writeKey("provider");
        generator.write(this.provider);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAzureAiStudioServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::endpointType, JsonpDeserializer.stringDeserializer(), "endpoint_type");
        op.add(Builder::target, JsonpDeserializer.stringDeserializer(), "target");
        op.add(Builder::provider, JsonpDeserializer.stringDeserializer(), "provider");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AzureAiStudioServiceSettings> {
        private String apiKey;
        private String endpointType;
        private String target;
        private String provider;
        @Nullable
        private RateLimitSetting rateLimit;

        public Builder() {
        }

        private Builder(AzureAiStudioServiceSettings instance) {
            this.apiKey = instance.apiKey;
            this.endpointType = instance.endpointType;
            this.target = instance.target;
            this.provider = instance.provider;
            this.rateLimit = instance.rateLimit;
        }

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder endpointType(String value) {
            this.endpointType = value;
            return this;
        }

        public final Builder target(String value) {
            this.target = value;
            return this;
        }

        public final Builder provider(String value) {
            this.provider = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AzureAiStudioServiceSettings build() {
            this._checkSingleUse();
            return new AzureAiStudioServiceSettings(this);
        }
    }
}

