/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AmazonBedrockTaskSettings
implements JsonpSerializable {
    @Nullable
    private final Integer maxNewTokens;
    @Nullable
    private final Float temperature;
    @Nullable
    private final Float topK;
    @Nullable
    private final Float topP;
    public static final JsonpDeserializer<AmazonBedrockTaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AmazonBedrockTaskSettings::setupAmazonBedrockTaskSettingsDeserializer);

    private AmazonBedrockTaskSettings(Builder builder) {
        this.maxNewTokens = builder.maxNewTokens;
        this.temperature = builder.temperature;
        this.topK = builder.topK;
        this.topP = builder.topP;
    }

    public static AmazonBedrockTaskSettings of(Function<Builder, ObjectBuilder<AmazonBedrockTaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxNewTokens() {
        return this.maxNewTokens;
    }

    @Nullable
    public final Float temperature() {
        return this.temperature;
    }

    @Nullable
    public final Float topK() {
        return this.topK;
    }

    @Nullable
    public final Float topP() {
        return this.topP;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxNewTokens != null) {
            generator.writeKey("max_new_tokens");
            generator.write(this.maxNewTokens.intValue());
        }
        if (this.temperature != null) {
            generator.writeKey("temperature");
            generator.write((double)this.temperature.floatValue());
        }
        if (this.topK != null) {
            generator.writeKey("top_k");
            generator.write((double)this.topK.floatValue());
        }
        if (this.topP != null) {
            generator.writeKey("top_p");
            generator.write((double)this.topP.floatValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAmazonBedrockTaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxNewTokens, JsonpDeserializer.integerDeserializer(), "max_new_tokens");
        op.add(Builder::temperature, JsonpDeserializer.floatDeserializer(), "temperature");
        op.add(Builder::topK, JsonpDeserializer.floatDeserializer(), "top_k");
        op.add(Builder::topP, JsonpDeserializer.floatDeserializer(), "top_p");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AmazonBedrockTaskSettings> {
        @Nullable
        private Integer maxNewTokens;
        @Nullable
        private Float temperature;
        @Nullable
        private Float topK;
        @Nullable
        private Float topP;

        public Builder() {
        }

        private Builder(AmazonBedrockTaskSettings instance) {
            this.maxNewTokens = instance.maxNewTokens;
            this.temperature = instance.temperature;
            this.topK = instance.topK;
            this.topP = instance.topP;
        }

        public final Builder maxNewTokens(@Nullable Integer value) {
            this.maxNewTokens = value;
            return this;
        }

        public final Builder temperature(@Nullable Float value) {
            this.temperature = value;
            return this;
        }

        public final Builder topK(@Nullable Float value) {
            this.topK = value;
            return this;
        }

        public final Builder topP(@Nullable Float value) {
            this.topP = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AmazonBedrockTaskSettings build() {
            this._checkSingleUse();
            return new AmazonBedrockTaskSettings(this);
        }
    }
}

