/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.reload_search_analyzers;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ReloadDetails
implements JsonpSerializable {
    private final String index;
    private final List<String> reloadedAnalyzers;
    private final List<String> reloadedNodeIds;
    public static final JsonpDeserializer<ReloadDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadDetails::setupReloadDetailsDeserializer);

    private ReloadDetails(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.reloadedAnalyzers = ApiTypeHelper.unmodifiableRequired(builder.reloadedAnalyzers, (Object)this, "reloadedAnalyzers");
        this.reloadedNodeIds = ApiTypeHelper.unmodifiableRequired(builder.reloadedNodeIds, (Object)this, "reloadedNodeIds");
    }

    public static ReloadDetails of(Function<Builder, ObjectBuilder<ReloadDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final List<String> reloadedAnalyzers() {
        return this.reloadedAnalyzers;
    }

    public final List<String> reloadedNodeIds() {
        return this.reloadedNodeIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (ApiTypeHelper.isDefined(this.reloadedAnalyzers)) {
            generator.writeKey("reloaded_analyzers");
            generator.writeStartArray();
            for (String item0 : this.reloadedAnalyzers) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.reloadedNodeIds)) {
            generator.writeKey("reloaded_node_ids");
            generator.writeStartArray();
            for (String item0 : this.reloadedNodeIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupReloadDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::reloadedAnalyzers, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "reloaded_analyzers");
        op.add(Builder::reloadedNodeIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "reloaded_node_ids");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ReloadDetails> {
        private String index;
        private List<String> reloadedAnalyzers;
        private List<String> reloadedNodeIds;

        public Builder() {
        }

        private Builder(ReloadDetails instance) {
            this.index = instance.index;
            this.reloadedAnalyzers = instance.reloadedAnalyzers;
            this.reloadedNodeIds = instance.reloadedNodeIds;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder reloadedAnalyzers(List<String> list) {
            this.reloadedAnalyzers = Builder._listAddAll(this.reloadedAnalyzers, list);
            return this;
        }

        public final Builder reloadedAnalyzers(String value, String ... values) {
            this.reloadedAnalyzers = Builder._listAdd(this.reloadedAnalyzers, value, values);
            return this;
        }

        public final Builder reloadedNodeIds(List<String> list) {
            this.reloadedNodeIds = Builder._listAddAll(this.reloadedNodeIds, list);
            return this;
        }

        public final Builder reloadedNodeIds(String value, String ... values) {
            this.reloadedNodeIds = Builder._listAdd(this.reloadedNodeIds, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ReloadDetails build() {
            this._checkSingleUse();
            return new ReloadDetails(this);
        }
    }
}

