/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.indices.CreateFromResponse;
import co.elastic.clients.elasticsearch.indices.create_from.CreateFrom;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class CreateFromRequest
extends RequestBase
implements JsonpSerializable {
    private final String dest;
    private final String source;
    private final CreateFrom createFrom;
    public static final JsonpDeserializer<CreateFromRequest> _DESERIALIZER = CreateFromRequest.createCreateFromRequestDeserializer();
    public static final Endpoint<CreateFromRequest, CreateFromResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateFromRequest, CreateFromResponse>("es/indices.create_from", request -> "PUT", request -> {
        boolean _source = true;
        int _dest = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_create_from");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.source, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.dest, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _source = true;
        int _dest = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("source", request.source);
            params.put("dest", request.dest);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, CreateFromResponse._DESERIALIZER);

    private CreateFromRequest(Builder builder) {
        this.dest = ApiTypeHelper.requireNonNull(builder.dest, this, "dest");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.createFrom = ApiTypeHelper.requireNonNull(builder.createFrom, this, "createFrom");
    }

    public static CreateFromRequest of(Function<Builder, ObjectBuilder<CreateFromRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String dest() {
        return this.dest;
    }

    public final String source() {
        return this.source;
    }

    public final CreateFrom createFrom() {
        return this.createFrom;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.createFrom.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static JsonpDeserializer<CreateFromRequest> createCreateFromRequestDeserializer() {
        JsonpDeserializer<CreateFrom> valueDeserializer = CreateFrom._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().createFrom((CreateFrom)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CreateFromRequest> {
        private String dest;
        private String source;
        private CreateFrom createFrom;

        public Builder() {
        }

        private Builder(CreateFromRequest instance) {
            this.dest = instance.dest;
            this.source = instance.source;
            this.createFrom = instance.createFrom;
        }

        public final Builder dest(String value) {
            this.dest = value;
            return this;
        }

        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        public final Builder createFrom(CreateFrom value) {
            this.createFrom = value;
            return this;
        }

        public final Builder createFrom(Function<CreateFrom.Builder, ObjectBuilder<CreateFrom>> fn) {
            return this.createFrom(fn.apply(new CreateFrom.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            CreateFrom value = CreateFrom._DESERIALIZER.deserialize(parser, mapper);
            return this.createFrom(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CreateFromRequest build() {
            this._checkSingleUse();
            return new CreateFromRequest(this);
        }
    }
}

