/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.graph;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Vertex
implements JsonpSerializable {
    private final long depth;
    private final String field;
    private final String term;
    private final double weight;
    public static final JsonpDeserializer<Vertex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Vertex::setupVertexDeserializer);

    private Vertex(Builder builder) {
        this.depth = ApiTypeHelper.requireNonNull(builder.depth, (Object)this, "depth", 0L);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.term = ApiTypeHelper.requireNonNull(builder.term, this, "term");
        this.weight = ApiTypeHelper.requireNonNull(builder.weight, (Object)this, "weight", 0.0);
    }

    public static Vertex of(Function<Builder, ObjectBuilder<Vertex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long depth() {
        return this.depth;
    }

    public final String field() {
        return this.field;
    }

    public final String term() {
        return this.term;
    }

    public final double weight() {
        return this.weight;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("depth");
        generator.write(this.depth);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("term");
        generator.write(this.term);
        generator.writeKey("weight");
        generator.write(this.weight);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupVertexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::depth, JsonpDeserializer.longDeserializer(), "depth");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::term, JsonpDeserializer.stringDeserializer(), "term");
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Vertex> {
        private Long depth;
        private String field;
        private String term;
        private Double weight;

        public Builder() {
        }

        private Builder(Vertex instance) {
            this.depth = instance.depth;
            this.field = instance.field;
            this.term = instance.term;
            this.weight = instance.weight;
        }

        public final Builder depth(long value) {
            this.depth = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder term(String value) {
            this.term = value;
            return this;
        }

        public final Builder weight(double value) {
            this.weight = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Vertex build() {
            this._checkSingleUse();
            return new Vertex(this);
        }
    }
}

