/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.enrich.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CacheStats
implements JsonpSerializable {
    private final String nodeId;
    private final int count;
    private final int hits;
    private final long hitsTimeInMillis;
    private final int misses;
    private final long missesTimeInMillis;
    private final int evictions;
    private final long sizeInBytes;
    public static final JsonpDeserializer<CacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CacheStats::setupCacheStatsDeserializer);

    private CacheStats(Builder builder) {
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, (Object)this, "hits", 0);
        this.hitsTimeInMillis = ApiTypeHelper.requireNonNull(builder.hitsTimeInMillis, (Object)this, "hitsTimeInMillis", 0L);
        this.misses = ApiTypeHelper.requireNonNull(builder.misses, (Object)this, "misses", 0);
        this.missesTimeInMillis = ApiTypeHelper.requireNonNull(builder.missesTimeInMillis, (Object)this, "missesTimeInMillis", 0L);
        this.evictions = ApiTypeHelper.requireNonNull(builder.evictions, (Object)this, "evictions", 0);
        this.sizeInBytes = ApiTypeHelper.requireNonNull(builder.sizeInBytes, (Object)this, "sizeInBytes", 0L);
    }

    public static CacheStats of(Function<Builder, ObjectBuilder<CacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final int count() {
        return this.count;
    }

    public final int hits() {
        return this.hits;
    }

    public final long hitsTimeInMillis() {
        return this.hitsTimeInMillis;
    }

    public final int misses() {
        return this.misses;
    }

    public final long missesTimeInMillis() {
        return this.missesTimeInMillis;
    }

    public final int evictions() {
        return this.evictions;
    }

    public final long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("hits");
        generator.write(this.hits);
        generator.writeKey("hits_time_in_millis");
        generator.write(this.hitsTimeInMillis);
        generator.writeKey("misses");
        generator.write(this.misses);
        generator.writeKey("misses_time_in_millis");
        generator.write(this.missesTimeInMillis);
        generator.writeKey("evictions");
        generator.write(this.evictions);
        generator.writeKey("size_in_bytes");
        generator.write(this.sizeInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::hits, JsonpDeserializer.integerDeserializer(), "hits");
        op.add(Builder::hitsTimeInMillis, JsonpDeserializer.longDeserializer(), "hits_time_in_millis");
        op.add(Builder::misses, JsonpDeserializer.integerDeserializer(), "misses");
        op.add(Builder::missesTimeInMillis, JsonpDeserializer.longDeserializer(), "misses_time_in_millis");
        op.add(Builder::evictions, JsonpDeserializer.integerDeserializer(), "evictions");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CacheStats> {
        private String nodeId;
        private Integer count;
        private Integer hits;
        private Long hitsTimeInMillis;
        private Integer misses;
        private Long missesTimeInMillis;
        private Integer evictions;
        private Long sizeInBytes;

        public Builder() {
        }

        private Builder(CacheStats instance) {
            this.nodeId = instance.nodeId;
            this.count = instance.count;
            this.hits = instance.hits;
            this.hitsTimeInMillis = instance.hitsTimeInMillis;
            this.misses = instance.misses;
            this.missesTimeInMillis = instance.missesTimeInMillis;
            this.evictions = instance.evictions;
            this.sizeInBytes = instance.sizeInBytes;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder hits(int value) {
            this.hits = value;
            return this;
        }

        public final Builder hitsTimeInMillis(long value) {
            this.hitsTimeInMillis = value;
            return this;
        }

        public final Builder misses(int value) {
            this.misses = value;
            return this;
        }

        public final Builder missesTimeInMillis(long value) {
            this.missesTimeInMillis = value;
            return this;
        }

        public final Builder evictions(int value) {
            this.evictions = value;
            return this;
        }

        public final Builder sizeInBytes(long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CacheStats build() {
            this._checkSingleUse();
            return new CacheStats(this);
        }
    }
}

