/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AggregationBreakdown
implements JsonpSerializable {
    private final long buildAggregation;
    private final long buildAggregationCount;
    private final long buildLeafCollector;
    private final long buildLeafCollectorCount;
    private final long collect;
    private final long collectCount;
    private final long initialize;
    private final long initializeCount;
    @Nullable
    private final Long postCollection;
    @Nullable
    private final Long postCollectionCount;
    private final long reduce;
    private final long reduceCount;
    public static final JsonpDeserializer<AggregationBreakdown> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AggregationBreakdown::setupAggregationBreakdownDeserializer);

    private AggregationBreakdown(Builder builder) {
        this.buildAggregation = ApiTypeHelper.requireNonNull(builder.buildAggregation, (Object)this, "buildAggregation", 0L);
        this.buildAggregationCount = ApiTypeHelper.requireNonNull(builder.buildAggregationCount, (Object)this, "buildAggregationCount", 0L);
        this.buildLeafCollector = ApiTypeHelper.requireNonNull(builder.buildLeafCollector, (Object)this, "buildLeafCollector", 0L);
        this.buildLeafCollectorCount = ApiTypeHelper.requireNonNull(builder.buildLeafCollectorCount, (Object)this, "buildLeafCollectorCount", 0L);
        this.collect = ApiTypeHelper.requireNonNull(builder.collect, (Object)this, "collect", 0L);
        this.collectCount = ApiTypeHelper.requireNonNull(builder.collectCount, (Object)this, "collectCount", 0L);
        this.initialize = ApiTypeHelper.requireNonNull(builder.initialize, (Object)this, "initialize", 0L);
        this.initializeCount = ApiTypeHelper.requireNonNull(builder.initializeCount, (Object)this, "initializeCount", 0L);
        this.postCollection = builder.postCollection;
        this.postCollectionCount = builder.postCollectionCount;
        this.reduce = ApiTypeHelper.requireNonNull(builder.reduce, (Object)this, "reduce", 0L);
        this.reduceCount = ApiTypeHelper.requireNonNull(builder.reduceCount, (Object)this, "reduceCount", 0L);
    }

    public static AggregationBreakdown of(Function<Builder, ObjectBuilder<AggregationBreakdown>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long buildAggregation() {
        return this.buildAggregation;
    }

    public final long buildAggregationCount() {
        return this.buildAggregationCount;
    }

    public final long buildLeafCollector() {
        return this.buildLeafCollector;
    }

    public final long buildLeafCollectorCount() {
        return this.buildLeafCollectorCount;
    }

    public final long collect() {
        return this.collect;
    }

    public final long collectCount() {
        return this.collectCount;
    }

    public final long initialize() {
        return this.initialize;
    }

    public final long initializeCount() {
        return this.initializeCount;
    }

    @Nullable
    public final Long postCollection() {
        return this.postCollection;
    }

    @Nullable
    public final Long postCollectionCount() {
        return this.postCollectionCount;
    }

    public final long reduce() {
        return this.reduce;
    }

    public final long reduceCount() {
        return this.reduceCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build_aggregation");
        generator.write(this.buildAggregation);
        generator.writeKey("build_aggregation_count");
        generator.write(this.buildAggregationCount);
        generator.writeKey("build_leaf_collector");
        generator.write(this.buildLeafCollector);
        generator.writeKey("build_leaf_collector_count");
        generator.write(this.buildLeafCollectorCount);
        generator.writeKey("collect");
        generator.write(this.collect);
        generator.writeKey("collect_count");
        generator.write(this.collectCount);
        generator.writeKey("initialize");
        generator.write(this.initialize);
        generator.writeKey("initialize_count");
        generator.write(this.initializeCount);
        if (this.postCollection != null) {
            generator.writeKey("post_collection");
            generator.write(this.postCollection.longValue());
        }
        if (this.postCollectionCount != null) {
            generator.writeKey("post_collection_count");
            generator.write(this.postCollectionCount.longValue());
        }
        generator.writeKey("reduce");
        generator.write(this.reduce);
        generator.writeKey("reduce_count");
        generator.write(this.reduceCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAggregationBreakdownDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::buildAggregation, JsonpDeserializer.longDeserializer(), "build_aggregation");
        op.add(Builder::buildAggregationCount, JsonpDeserializer.longDeserializer(), "build_aggregation_count");
        op.add(Builder::buildLeafCollector, JsonpDeserializer.longDeserializer(), "build_leaf_collector");
        op.add(Builder::buildLeafCollectorCount, JsonpDeserializer.longDeserializer(), "build_leaf_collector_count");
        op.add(Builder::collect, JsonpDeserializer.longDeserializer(), "collect");
        op.add(Builder::collectCount, JsonpDeserializer.longDeserializer(), "collect_count");
        op.add(Builder::initialize, JsonpDeserializer.longDeserializer(), "initialize");
        op.add(Builder::initializeCount, JsonpDeserializer.longDeserializer(), "initialize_count");
        op.add(Builder::postCollection, JsonpDeserializer.longDeserializer(), "post_collection");
        op.add(Builder::postCollectionCount, JsonpDeserializer.longDeserializer(), "post_collection_count");
        op.add(Builder::reduce, JsonpDeserializer.longDeserializer(), "reduce");
        op.add(Builder::reduceCount, JsonpDeserializer.longDeserializer(), "reduce_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AggregationBreakdown> {
        private Long buildAggregation;
        private Long buildAggregationCount;
        private Long buildLeafCollector;
        private Long buildLeafCollectorCount;
        private Long collect;
        private Long collectCount;
        private Long initialize;
        private Long initializeCount;
        @Nullable
        private Long postCollection;
        @Nullable
        private Long postCollectionCount;
        private Long reduce;
        private Long reduceCount;

        public Builder() {
        }

        private Builder(AggregationBreakdown instance) {
            this.buildAggregation = instance.buildAggregation;
            this.buildAggregationCount = instance.buildAggregationCount;
            this.buildLeafCollector = instance.buildLeafCollector;
            this.buildLeafCollectorCount = instance.buildLeafCollectorCount;
            this.collect = instance.collect;
            this.collectCount = instance.collectCount;
            this.initialize = instance.initialize;
            this.initializeCount = instance.initializeCount;
            this.postCollection = instance.postCollection;
            this.postCollectionCount = instance.postCollectionCount;
            this.reduce = instance.reduce;
            this.reduceCount = instance.reduceCount;
        }

        public final Builder buildAggregation(long value) {
            this.buildAggregation = value;
            return this;
        }

        public final Builder buildAggregationCount(long value) {
            this.buildAggregationCount = value;
            return this;
        }

        public final Builder buildLeafCollector(long value) {
            this.buildLeafCollector = value;
            return this;
        }

        public final Builder buildLeafCollectorCount(long value) {
            this.buildLeafCollectorCount = value;
            return this;
        }

        public final Builder collect(long value) {
            this.collect = value;
            return this;
        }

        public final Builder collectCount(long value) {
            this.collectCount = value;
            return this;
        }

        public final Builder initialize(long value) {
            this.initialize = value;
            return this;
        }

        public final Builder initializeCount(long value) {
            this.initializeCount = value;
            return this;
        }

        public final Builder postCollection(@Nullable Long value) {
            this.postCollection = value;
            return this;
        }

        public final Builder postCollectionCount(@Nullable Long value) {
            this.postCollectionCount = value;
            return this;
        }

        public final Builder reduce(long value) {
            this.reduce = value;
            return this;
        }

        public final Builder reduceCount(long value) {
            this.reduceCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AggregationBreakdown build() {
            this._checkSingleUse();
            return new AggregationBreakdown(this);
        }
    }
}

