/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.elasticsearch.core.health_report.StagnatingBackingIndices;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamLifecycleDetails
implements JsonpSerializable {
    private final int stagnatingBackingIndicesCount;
    private final int totalBackingIndicesInError;
    private final List<StagnatingBackingIndices> stagnatingBackingIndices;
    public static final JsonpDeserializer<DataStreamLifecycleDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamLifecycleDetails::setupDataStreamLifecycleDetailsDeserializer);

    private DataStreamLifecycleDetails(Builder builder) {
        this.stagnatingBackingIndicesCount = ApiTypeHelper.requireNonNull(builder.stagnatingBackingIndicesCount, (Object)this, "stagnatingBackingIndicesCount", 0);
        this.totalBackingIndicesInError = ApiTypeHelper.requireNonNull(builder.totalBackingIndicesInError, (Object)this, "totalBackingIndicesInError", 0);
        this.stagnatingBackingIndices = ApiTypeHelper.unmodifiable(builder.stagnatingBackingIndices);
    }

    public static DataStreamLifecycleDetails of(Function<Builder, ObjectBuilder<DataStreamLifecycleDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int stagnatingBackingIndicesCount() {
        return this.stagnatingBackingIndicesCount;
    }

    public final int totalBackingIndicesInError() {
        return this.totalBackingIndicesInError;
    }

    public final List<StagnatingBackingIndices> stagnatingBackingIndices() {
        return this.stagnatingBackingIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("stagnating_backing_indices_count");
        generator.write(this.stagnatingBackingIndicesCount);
        generator.writeKey("total_backing_indices_in_error");
        generator.write(this.totalBackingIndicesInError);
        if (ApiTypeHelper.isDefined(this.stagnatingBackingIndices)) {
            generator.writeKey("stagnating_backing_indices");
            generator.writeStartArray();
            for (StagnatingBackingIndices item0 : this.stagnatingBackingIndices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataStreamLifecycleDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::stagnatingBackingIndicesCount, JsonpDeserializer.integerDeserializer(), "stagnating_backing_indices_count");
        op.add(Builder::totalBackingIndicesInError, JsonpDeserializer.integerDeserializer(), "total_backing_indices_in_error");
        op.add(Builder::stagnatingBackingIndices, JsonpDeserializer.arrayDeserializer(StagnatingBackingIndices._DESERIALIZER), "stagnating_backing_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamLifecycleDetails> {
        private Integer stagnatingBackingIndicesCount;
        private Integer totalBackingIndicesInError;
        @Nullable
        private List<StagnatingBackingIndices> stagnatingBackingIndices;

        public Builder() {
        }

        private Builder(DataStreamLifecycleDetails instance) {
            this.stagnatingBackingIndicesCount = instance.stagnatingBackingIndicesCount;
            this.totalBackingIndicesInError = instance.totalBackingIndicesInError;
            this.stagnatingBackingIndices = instance.stagnatingBackingIndices;
        }

        public final Builder stagnatingBackingIndicesCount(int value) {
            this.stagnatingBackingIndicesCount = value;
            return this;
        }

        public final Builder totalBackingIndicesInError(int value) {
            this.totalBackingIndicesInError = value;
            return this;
        }

        public final Builder stagnatingBackingIndices(List<StagnatingBackingIndices> list) {
            this.stagnatingBackingIndices = Builder._listAddAll(this.stagnatingBackingIndices, list);
            return this;
        }

        public final Builder stagnatingBackingIndices(StagnatingBackingIndices value, StagnatingBackingIndices ... values) {
            this.stagnatingBackingIndices = Builder._listAdd(this.stagnatingBackingIndices, value, values);
            return this;
        }

        public final Builder stagnatingBackingIndices(Function<StagnatingBackingIndices.Builder, ObjectBuilder<StagnatingBackingIndices>> fn) {
            return this.stagnatingBackingIndices(fn.apply(new StagnatingBackingIndices.Builder()).build(), new StagnatingBackingIndices[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamLifecycleDetails build() {
            this._checkSingleUse();
            return new DataStreamLifecycleDetails(this);
        }
    }
}

