/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.FilteringRulesValidation;
import co.elastic.clients.elasticsearch.connector.UpdateFilteringValidationResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

@JsonpDeserializable
public class UpdateFilteringValidationRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorId;
    private final FilteringRulesValidation validation;
    public static final JsonpDeserializer<UpdateFilteringValidationRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateFilteringValidationRequest::setupUpdateFilteringValidationRequestDeserializer);
    public static final Endpoint<UpdateFilteringValidationRequest, UpdateFilteringValidationResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateFilteringValidationRequest, UpdateFilteringValidationResponse>("es/connector.update_filtering_validation", request -> "PUT", request -> {
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorId, buf);
            buf.append("/_filtering");
            buf.append("/_validation");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorId", request.connectorId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateFilteringValidationResponse._DESERIALIZER);

    private UpdateFilteringValidationRequest(Builder builder) {
        this.connectorId = ApiTypeHelper.requireNonNull(builder.connectorId, this, "connectorId");
        this.validation = ApiTypeHelper.requireNonNull(builder.validation, this, "validation");
    }

    public static UpdateFilteringValidationRequest of(Function<Builder, ObjectBuilder<UpdateFilteringValidationRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorId() {
        return this.connectorId;
    }

    public final FilteringRulesValidation validation() {
        return this.validation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("validation");
        this.validation.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateFilteringValidationRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::validation, FilteringRulesValidation._DESERIALIZER, "validation");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateFilteringValidationRequest> {
        private String connectorId;
        private FilteringRulesValidation validation;

        public Builder() {
        }

        private Builder(UpdateFilteringValidationRequest instance) {
            this.connectorId = instance.connectorId;
            this.validation = instance.validation;
        }

        public final Builder connectorId(String value) {
            this.connectorId = value;
            return this;
        }

        public final Builder validation(FilteringRulesValidation value) {
            this.validation = value;
            return this;
        }

        public final Builder validation(Function<FilteringRulesValidation.Builder, ObjectBuilder<FilteringRulesValidation>> fn) {
            return this.validation(fn.apply(new FilteringRulesValidation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateFilteringValidationRequest build() {
            this._checkSingleUse();
            return new UpdateFilteringValidationRequest(this);
        }
    }
}

