/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.connector.SyncJobClaimResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SyncJobClaimRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorSyncJobId;
    @Nullable
    private final JsonData syncCursor;
    private final String workerHostname;
    public static final JsonpDeserializer<SyncJobClaimRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SyncJobClaimRequest::setupSyncJobClaimRequestDeserializer);
    public static final Endpoint<SyncJobClaimRequest, SyncJobClaimResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SyncJobClaimRequest, SyncJobClaimResponse>("es/connector.sync_job_claim", request -> "PUT", request -> {
        boolean _connectorSyncJobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/_sync_job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorSyncJobId, buf);
            buf.append("/_claim");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorSyncJobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorSyncJobId", request.connectorSyncJobId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SyncJobClaimResponse._DESERIALIZER);

    private SyncJobClaimRequest(Builder builder) {
        this.connectorSyncJobId = ApiTypeHelper.requireNonNull(builder.connectorSyncJobId, this, "connectorSyncJobId");
        this.syncCursor = builder.syncCursor;
        this.workerHostname = ApiTypeHelper.requireNonNull(builder.workerHostname, this, "workerHostname");
    }

    public static SyncJobClaimRequest of(Function<Builder, ObjectBuilder<SyncJobClaimRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorSyncJobId() {
        return this.connectorSyncJobId;
    }

    @Nullable
    public final JsonData syncCursor() {
        return this.syncCursor;
    }

    public final String workerHostname() {
        return this.workerHostname;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.syncCursor != null) {
            generator.writeKey("sync_cursor");
            this.syncCursor.serialize(generator, mapper);
        }
        generator.writeKey("worker_hostname");
        generator.write(this.workerHostname);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSyncJobClaimRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::syncCursor, JsonData._DESERIALIZER, "sync_cursor");
        op.add(Builder::workerHostname, JsonpDeserializer.stringDeserializer(), "worker_hostname");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SyncJobClaimRequest> {
        private String connectorSyncJobId;
        @Nullable
        private JsonData syncCursor;
        private String workerHostname;

        public Builder() {
        }

        private Builder(SyncJobClaimRequest instance) {
            this.connectorSyncJobId = instance.connectorSyncJobId;
            this.syncCursor = instance.syncCursor;
            this.workerHostname = instance.workerHostname;
        }

        public final Builder connectorSyncJobId(String value) {
            this.connectorSyncJobId = value;
            return this;
        }

        public final Builder syncCursor(@Nullable JsonData value) {
            this.syncCursor = value;
            return this;
        }

        public final Builder workerHostname(String value) {
            this.workerHostname = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SyncJobClaimRequest build() {
            this._checkSingleUse();
            return new SyncJobClaimRequest(this);
        }
    }
}

