/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FilteringValidation
implements JsonpSerializable {
    private final List<String> ids;
    private final List<String> messages;
    public static final JsonpDeserializer<FilteringValidation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilteringValidation::setupFilteringValidationDeserializer);

    private FilteringValidation(Builder builder) {
        this.ids = ApiTypeHelper.unmodifiableRequired(builder.ids, (Object)this, "ids");
        this.messages = ApiTypeHelper.unmodifiableRequired(builder.messages, (Object)this, "messages");
    }

    public static FilteringValidation of(Function<Builder, ObjectBuilder<FilteringValidation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> ids() {
        return this.ids;
    }

    public final List<String> messages() {
        return this.messages;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.ids)) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String item0 : this.ids) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.messages)) {
            generator.writeKey("messages");
            generator.writeStartArray();
            for (String item0 : this.messages) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFilteringValidationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids");
        op.add(Builder::messages, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "messages");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilteringValidation> {
        private List<String> ids;
        private List<String> messages;

        public Builder() {
        }

        private Builder(FilteringValidation instance) {
            this.ids = instance.ids;
            this.messages = instance.messages;
        }

        public final Builder ids(List<String> list) {
            this.ids = Builder._listAddAll(this.ids, list);
            return this;
        }

        public final Builder ids(String value, String ... values) {
            this.ids = Builder._listAdd(this.ids, value, values);
            return this;
        }

        public final Builder messages(List<String> list) {
            this.messages = Builder._listAddAll(this.messages, list);
            return this;
        }

        public final Builder messages(String value, String ... values) {
            this.messages = Builder._listAdd(this.messages, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilteringValidation build() {
            this._checkSingleUse();
            return new FilteringValidation(this);
        }
    }
}

