/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class OperatingSystemMemoryInfo
implements JsonpSerializable {
    @Nullable
    private final Long adjustedTotalInBytes;
    @Nullable
    private final String adjustedTotal;
    private final long freeInBytes;
    @Nullable
    private final String free;
    private final int freePercent;
    private final long totalInBytes;
    @Nullable
    private final String total;
    private final long usedInBytes;
    @Nullable
    private final String used;
    private final int usedPercent;
    public static final JsonpDeserializer<OperatingSystemMemoryInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystemMemoryInfo::setupOperatingSystemMemoryInfoDeserializer);

    private OperatingSystemMemoryInfo(Builder builder) {
        this.adjustedTotalInBytes = builder.adjustedTotalInBytes;
        this.adjustedTotal = builder.adjustedTotal;
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, (Object)this, "freeInBytes", 0L);
        this.free = builder.free;
        this.freePercent = ApiTypeHelper.requireNonNull(builder.freePercent, (Object)this, "freePercent", 0);
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, (Object)this, "totalInBytes", 0L);
        this.total = builder.total;
        this.usedInBytes = ApiTypeHelper.requireNonNull(builder.usedInBytes, (Object)this, "usedInBytes", 0L);
        this.used = builder.used;
        this.usedPercent = ApiTypeHelper.requireNonNull(builder.usedPercent, (Object)this, "usedPercent", 0);
    }

    public static OperatingSystemMemoryInfo of(Function<Builder, ObjectBuilder<OperatingSystemMemoryInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long adjustedTotalInBytes() {
        return this.adjustedTotalInBytes;
    }

    @Nullable
    public final String adjustedTotal() {
        return this.adjustedTotal;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    @Nullable
    public final String free() {
        return this.free;
    }

    public final int freePercent() {
        return this.freePercent;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    public final long usedInBytes() {
        return this.usedInBytes;
    }

    @Nullable
    public final String used() {
        return this.used;
    }

    public final int usedPercent() {
        return this.usedPercent;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adjustedTotalInBytes != null) {
            generator.writeKey("adjusted_total_in_bytes");
            generator.write(this.adjustedTotalInBytes.longValue());
        }
        if (this.adjustedTotal != null) {
            generator.writeKey("adjusted_total");
            generator.write(this.adjustedTotal);
        }
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        if (this.free != null) {
            generator.writeKey("free");
            generator.write(this.free);
        }
        generator.writeKey("free_percent");
        generator.write(this.freePercent);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        generator.writeKey("used_in_bytes");
        generator.write(this.usedInBytes);
        if (this.used != null) {
            generator.writeKey("used");
            generator.write(this.used);
        }
        generator.writeKey("used_percent");
        generator.write(this.usedPercent);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupOperatingSystemMemoryInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adjustedTotalInBytes, JsonpDeserializer.longDeserializer(), "adjusted_total_in_bytes");
        op.add(Builder::adjustedTotal, JsonpDeserializer.stringDeserializer(), "adjusted_total");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(Builder::freePercent, JsonpDeserializer.integerDeserializer(), "free_percent");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
        op.add(Builder::used, JsonpDeserializer.stringDeserializer(), "used");
        op.add(Builder::usedPercent, JsonpDeserializer.integerDeserializer(), "used_percent");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<OperatingSystemMemoryInfo> {
        @Nullable
        private Long adjustedTotalInBytes;
        @Nullable
        private String adjustedTotal;
        private Long freeInBytes;
        @Nullable
        private String free;
        private Integer freePercent;
        private Long totalInBytes;
        @Nullable
        private String total;
        private Long usedInBytes;
        @Nullable
        private String used;
        private Integer usedPercent;

        public Builder() {
        }

        private Builder(OperatingSystemMemoryInfo instance) {
            this.adjustedTotalInBytes = instance.adjustedTotalInBytes;
            this.adjustedTotal = instance.adjustedTotal;
            this.freeInBytes = instance.freeInBytes;
            this.free = instance.free;
            this.freePercent = instance.freePercent;
            this.totalInBytes = instance.totalInBytes;
            this.total = instance.total;
            this.usedInBytes = instance.usedInBytes;
            this.used = instance.used;
            this.usedPercent = instance.usedPercent;
        }

        public final Builder adjustedTotalInBytes(@Nullable Long value) {
            this.adjustedTotalInBytes = value;
            return this;
        }

        public final Builder adjustedTotal(@Nullable String value) {
            this.adjustedTotal = value;
            return this;
        }

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder free(@Nullable String value) {
            this.free = value;
            return this;
        }

        public final Builder freePercent(int value) {
            this.freePercent = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public final Builder usedInBytes(long value) {
            this.usedInBytes = value;
            return this;
        }

        public final Builder used(@Nullable String value) {
            this.used = value;
            return this;
        }

        public final Builder usedPercent(int value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public OperatingSystemMemoryInfo build() {
            this._checkSingleUse();
            return new OperatingSystemMemoryInfo(this);
        }
    }
}

