/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.CCSUsageClusterStats;
import co.elastic.clients.elasticsearch.cluster.stats.CCSUsageTimeValue;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CCSUsageStats
implements JsonpSerializable {
    private final int total;
    private final int success;
    private final int skipped;
    private final CCSUsageTimeValue took;
    @Nullable
    private final CCSUsageTimeValue tookMrtTrue;
    @Nullable
    private final CCSUsageTimeValue tookMrtFalse;
    private final int remotesPerSearchMax;
    private final double remotesPerSearchAvg;
    private final Map<String, Integer> failureReasons;
    private final Map<String, Integer> features;
    private final Map<String, Integer> clients;
    private final Map<String, CCSUsageClusterStats> clusters;
    public static final JsonpDeserializer<CCSUsageStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CCSUsageStats::setupCCSUsageStatsDeserializer);

    private CCSUsageStats(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0);
        this.success = ApiTypeHelper.requireNonNull(builder.success, (Object)this, "success", 0);
        this.skipped = ApiTypeHelper.requireNonNull(builder.skipped, (Object)this, "skipped", 0);
        this.took = ApiTypeHelper.requireNonNull(builder.took, this, "took");
        this.tookMrtTrue = builder.tookMrtTrue;
        this.tookMrtFalse = builder.tookMrtFalse;
        this.remotesPerSearchMax = ApiTypeHelper.requireNonNull(builder.remotesPerSearchMax, (Object)this, "remotesPerSearchMax", 0);
        this.remotesPerSearchAvg = ApiTypeHelper.requireNonNull(builder.remotesPerSearchAvg, (Object)this, "remotesPerSearchAvg", 0.0);
        this.failureReasons = ApiTypeHelper.unmodifiableRequired(builder.failureReasons, (Object)this, "failureReasons");
        this.features = ApiTypeHelper.unmodifiableRequired(builder.features, (Object)this, "features");
        this.clients = ApiTypeHelper.unmodifiableRequired(builder.clients, (Object)this, "clients");
        this.clusters = ApiTypeHelper.unmodifiableRequired(builder.clusters, (Object)this, "clusters");
    }

    public static CCSUsageStats of(Function<Builder, ObjectBuilder<CCSUsageStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    public final int success() {
        return this.success;
    }

    public final int skipped() {
        return this.skipped;
    }

    public final CCSUsageTimeValue took() {
        return this.took;
    }

    @Nullable
    public final CCSUsageTimeValue tookMrtTrue() {
        return this.tookMrtTrue;
    }

    @Nullable
    public final CCSUsageTimeValue tookMrtFalse() {
        return this.tookMrtFalse;
    }

    public final int remotesPerSearchMax() {
        return this.remotesPerSearchMax;
    }

    public final double remotesPerSearchAvg() {
        return this.remotesPerSearchAvg;
    }

    public final Map<String, Integer> failureReasons() {
        return this.failureReasons;
    }

    public final Map<String, Integer> features() {
        return this.features;
    }

    public final Map<String, Integer> clients() {
        return this.clients;
    }

    public final Map<String, CCSUsageClusterStats> clusters() {
        return this.clusters;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("success");
        generator.write(this.success);
        generator.writeKey("skipped");
        generator.write(this.skipped);
        generator.writeKey("took");
        this.took.serialize(generator, mapper);
        if (this.tookMrtTrue != null) {
            generator.writeKey("took_mrt_true");
            this.tookMrtTrue.serialize(generator, mapper);
        }
        if (this.tookMrtFalse != null) {
            generator.writeKey("took_mrt_false");
            this.tookMrtFalse.serialize(generator, mapper);
        }
        generator.writeKey("remotes_per_search_max");
        generator.write(this.remotesPerSearchMax);
        generator.writeKey("remotes_per_search_avg");
        generator.write(this.remotesPerSearchAvg);
        if (ApiTypeHelper.isDefined(this.failureReasons)) {
            generator.writeKey("failure_reasons");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.failureReasons.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.features)) {
            generator.writeKey("features");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.features.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.clients)) {
            generator.writeKey("clients");
            generator.writeStartObject();
            for (Map.Entry<String, Integer> entry : this.clients.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().intValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.clusters)) {
            generator.writeKey("clusters");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.clusters.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CCSUsageClusterStats)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCCSUsageStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::success, JsonpDeserializer.integerDeserializer(), "success");
        op.add(Builder::skipped, JsonpDeserializer.integerDeserializer(), "skipped");
        op.add(Builder::took, CCSUsageTimeValue._DESERIALIZER, "took");
        op.add(Builder::tookMrtTrue, CCSUsageTimeValue._DESERIALIZER, "took_mrt_true");
        op.add(Builder::tookMrtFalse, CCSUsageTimeValue._DESERIALIZER, "took_mrt_false");
        op.add(Builder::remotesPerSearchMax, JsonpDeserializer.integerDeserializer(), "remotes_per_search_max");
        op.add(Builder::remotesPerSearchAvg, JsonpDeserializer.doubleDeserializer(), "remotes_per_search_avg");
        op.add(Builder::failureReasons, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "failure_reasons");
        op.add(Builder::features, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "features");
        op.add(Builder::clients, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.integerDeserializer()), "clients");
        op.add(Builder::clusters, JsonpDeserializer.stringMapDeserializer(CCSUsageClusterStats._DESERIALIZER), "clusters");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CCSUsageStats> {
        private Integer total;
        private Integer success;
        private Integer skipped;
        private CCSUsageTimeValue took;
        @Nullable
        private CCSUsageTimeValue tookMrtTrue;
        @Nullable
        private CCSUsageTimeValue tookMrtFalse;
        private Integer remotesPerSearchMax;
        private Double remotesPerSearchAvg;
        private Map<String, Integer> failureReasons;
        private Map<String, Integer> features;
        private Map<String, Integer> clients;
        private Map<String, CCSUsageClusterStats> clusters;

        public Builder() {
        }

        private Builder(CCSUsageStats instance) {
            this.total = instance.total;
            this.success = instance.success;
            this.skipped = instance.skipped;
            this.took = instance.took;
            this.tookMrtTrue = instance.tookMrtTrue;
            this.tookMrtFalse = instance.tookMrtFalse;
            this.remotesPerSearchMax = instance.remotesPerSearchMax;
            this.remotesPerSearchAvg = instance.remotesPerSearchAvg;
            this.failureReasons = instance.failureReasons;
            this.features = instance.features;
            this.clients = instance.clients;
            this.clusters = instance.clusters;
        }

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder success(int value) {
            this.success = value;
            return this;
        }

        public final Builder skipped(int value) {
            this.skipped = value;
            return this;
        }

        public final Builder took(CCSUsageTimeValue value) {
            this.took = value;
            return this;
        }

        public final Builder took(Function<CCSUsageTimeValue.Builder, ObjectBuilder<CCSUsageTimeValue>> fn) {
            return this.took(fn.apply(new CCSUsageTimeValue.Builder()).build());
        }

        public final Builder tookMrtTrue(@Nullable CCSUsageTimeValue value) {
            this.tookMrtTrue = value;
            return this;
        }

        public final Builder tookMrtTrue(Function<CCSUsageTimeValue.Builder, ObjectBuilder<CCSUsageTimeValue>> fn) {
            return this.tookMrtTrue(fn.apply(new CCSUsageTimeValue.Builder()).build());
        }

        public final Builder tookMrtFalse(@Nullable CCSUsageTimeValue value) {
            this.tookMrtFalse = value;
            return this;
        }

        public final Builder tookMrtFalse(Function<CCSUsageTimeValue.Builder, ObjectBuilder<CCSUsageTimeValue>> fn) {
            return this.tookMrtFalse(fn.apply(new CCSUsageTimeValue.Builder()).build());
        }

        public final Builder remotesPerSearchMax(int value) {
            this.remotesPerSearchMax = value;
            return this;
        }

        public final Builder remotesPerSearchAvg(double value) {
            this.remotesPerSearchAvg = value;
            return this;
        }

        public final Builder failureReasons(Map<String, Integer> map) {
            this.failureReasons = Builder._mapPutAll(this.failureReasons, map);
            return this;
        }

        public final Builder failureReasons(String key, Integer value) {
            this.failureReasons = Builder._mapPut(this.failureReasons, key, value);
            return this;
        }

        public final Builder features(Map<String, Integer> map) {
            this.features = Builder._mapPutAll(this.features, map);
            return this;
        }

        public final Builder features(String key, Integer value) {
            this.features = Builder._mapPut(this.features, key, value);
            return this;
        }

        public final Builder clients(Map<String, Integer> map) {
            this.clients = Builder._mapPutAll(this.clients, map);
            return this;
        }

        public final Builder clients(String key, Integer value) {
            this.clients = Builder._mapPut(this.clients, key, value);
            return this;
        }

        public final Builder clusters(Map<String, CCSUsageClusterStats> map) {
            this.clusters = Builder._mapPutAll(this.clusters, map);
            return this;
        }

        public final Builder clusters(String key, CCSUsageClusterStats value) {
            this.clusters = Builder._mapPut(this.clusters, key, value);
            return this;
        }

        public final Builder clusters(String key, Function<CCSUsageClusterStats.Builder, ObjectBuilder<CCSUsageClusterStats>> fn) {
            return this.clusters(key, fn.apply(new CCSUsageClusterStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CCSUsageStats build() {
            this._checkSingleUse();
            return new CCSUsageStats(this);
        }
    }
}

