/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.pending_tasks;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PendingTask
implements JsonpSerializable {
    private final boolean executing;
    private final int insertOrder;
    private final String priority;
    private final String source;
    @Nullable
    private final Time timeInQueue;
    private final long timeInQueueMillis;
    public static final JsonpDeserializer<PendingTask> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PendingTask::setupPendingTaskDeserializer);

    private PendingTask(Builder builder) {
        this.executing = ApiTypeHelper.requireNonNull(builder.executing, (Object)this, "executing", false);
        this.insertOrder = ApiTypeHelper.requireNonNull(builder.insertOrder, (Object)this, "insertOrder", 0);
        this.priority = ApiTypeHelper.requireNonNull(builder.priority, this, "priority");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
        this.timeInQueue = builder.timeInQueue;
        this.timeInQueueMillis = ApiTypeHelper.requireNonNull(builder.timeInQueueMillis, (Object)this, "timeInQueueMillis", 0L);
    }

    public static PendingTask of(Function<Builder, ObjectBuilder<PendingTask>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean executing() {
        return this.executing;
    }

    public final int insertOrder() {
        return this.insertOrder;
    }

    public final String priority() {
        return this.priority;
    }

    public final String source() {
        return this.source;
    }

    @Nullable
    public final Time timeInQueue() {
        return this.timeInQueue;
    }

    public final long timeInQueueMillis() {
        return this.timeInQueueMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("executing");
        generator.write(this.executing);
        generator.writeKey("insert_order");
        generator.write(this.insertOrder);
        generator.writeKey("priority");
        generator.write(this.priority);
        generator.writeKey("source");
        generator.write(this.source);
        if (this.timeInQueue != null) {
            generator.writeKey("time_in_queue");
            this.timeInQueue.serialize(generator, mapper);
        }
        generator.writeKey("time_in_queue_millis");
        generator.write(this.timeInQueueMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPendingTaskDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::executing, JsonpDeserializer.booleanDeserializer(), "executing");
        op.add(Builder::insertOrder, JsonpDeserializer.integerDeserializer(), "insert_order");
        op.add(Builder::priority, JsonpDeserializer.stringDeserializer(), "priority");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
        op.add(Builder::timeInQueue, Time._DESERIALIZER, "time_in_queue");
        op.add(Builder::timeInQueueMillis, JsonpDeserializer.longDeserializer(), "time_in_queue_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PendingTask> {
        private Boolean executing;
        private Integer insertOrder;
        private String priority;
        private String source;
        @Nullable
        private Time timeInQueue;
        private Long timeInQueueMillis;

        public Builder() {
        }

        private Builder(PendingTask instance) {
            this.executing = instance.executing;
            this.insertOrder = instance.insertOrder;
            this.priority = instance.priority;
            this.source = instance.source;
            this.timeInQueue = instance.timeInQueue;
            this.timeInQueueMillis = instance.timeInQueueMillis;
        }

        public final Builder executing(boolean value) {
            this.executing = value;
            return this;
        }

        public final Builder insertOrder(int value) {
            this.insertOrder = value;
            return this;
        }

        public final Builder priority(String value) {
            this.priority = value;
            return this;
        }

        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        public final Builder timeInQueue(@Nullable Time value) {
            this.timeInQueue = value;
            return this;
        }

        public final Builder timeInQueue(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeInQueue(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeInQueueMillis(long value) {
            this.timeInQueueMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PendingTask build() {
            this._checkSingleUse();
            return new PendingTask(this);
        }
    }
}

