/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryBase;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateRangeQuery
extends RangeQueryBase<String>
implements RangeQueryVariant {
    private final String field;
    @Nullable
    private final String format;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<DateRangeQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateRangeQuery::setupDateRangeQueryDeserializer);

    private DateRangeQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.format = builder.format;
        this.timeZone = builder.timeZone;
    }

    public static DateRangeQuery of(Function<Builder, ObjectBuilder<DateRangeQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RangeQuery.Kind _rangeQueryKind() {
        return RangeQuery.Kind.Date;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
        generator.writeEnd();
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDateRangeQueryDeserializer(ObjectDeserializer<Builder> op) {
        RangeQueryBase.setupRangeQueryBaseDeserializer(op, JsonpDeserializer.stringDeserializer());
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
    }

    public static class Builder
    extends RangeQueryBase.AbstractBuilder<String, Builder>
    implements ObjectBuilder<DateRangeQuery> {
        private String field;
        @Nullable
        private String format;
        @Nullable
        private String timeZone;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public Builder() {
        }

        private Builder(DateRangeQuery instance) {
            this.format = instance.format;
            this.timeZone = instance.timeZone;
        }

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateRangeQuery build() {
            this._checkSingleUse();
            super.tSerializer(null);
            return new DateRangeQuery(this);
        }
    }
}

