/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.OnScriptError;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.PropertyVariant;
import co.elastic.clients.elasticsearch.indices.NumericFielddata;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BooleanProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final NumericFielddata fielddata;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Boolean nullValue;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Script script;
    @Nullable
    private final OnScriptError onScriptError;
    @Nullable
    private final Boolean timeSeriesDimension;
    public static final JsonpDeserializer<BooleanProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BooleanProperty::setupBooleanPropertyDeserializer);

    private BooleanProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.fielddata = builder.fielddata;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.script = builder.script;
        this.onScriptError = builder.onScriptError;
        this.timeSeriesDimension = builder.timeSeriesDimension;
    }

    public static BooleanProperty of(Function<Builder, ObjectBuilder<BooleanProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Boolean;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final NumericFielddata fielddata() {
        return this.fielddata;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Boolean nullValue() {
        return this.nullValue;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Nullable
    public final OnScriptError onScriptError() {
        return this.onScriptError;
    }

    @Nullable
    public final Boolean timeSeriesDimension() {
        return this.timeSeriesDimension;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "boolean");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            this.fielddata.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
        if (this.onScriptError != null) {
            generator.writeKey("on_script_error");
            this.onScriptError.serialize(generator, mapper);
        }
        if (this.timeSeriesDimension != null) {
            generator.writeKey("time_series_dimension");
            generator.write(this.timeSeriesDimension.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupBooleanPropertyDeserializer(ObjectDeserializer<Builder> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::fielddata, NumericFielddata._DESERIALIZER, "fielddata");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::nullValue, JsonpDeserializer.booleanDeserializer(), "null_value");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::onScriptError, OnScriptError._DESERIALIZER, "on_script_error");
        op.add(Builder::timeSeriesDimension, JsonpDeserializer.booleanDeserializer(), "time_series_dimension");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BooleanProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private NumericFielddata fielddata;
        @Nullable
        private Boolean index;
        @Nullable
        private Boolean nullValue;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Script script;
        @Nullable
        private OnScriptError onScriptError;
        @Nullable
        private Boolean timeSeriesDimension;

        public Builder() {
        }

        private Builder(BooleanProperty instance) {
            this.boost = instance.boost;
            this.fielddata = instance.fielddata;
            this.index = instance.index;
            this.nullValue = instance.nullValue;
            this.ignoreMalformed = instance.ignoreMalformed;
            this.script = instance.script;
            this.onScriptError = instance.onScriptError;
            this.timeSeriesDimension = instance.timeSeriesDimension;
        }

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder fielddata(@Nullable NumericFielddata value) {
            this.fielddata = value;
            return this;
        }

        public final Builder fielddata(Function<NumericFielddata.Builder, ObjectBuilder<NumericFielddata>> fn) {
            return this.fielddata(fn.apply(new NumericFielddata.Builder()).build());
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder nullValue(@Nullable Boolean value) {
            this.nullValue = value;
            return this;
        }

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        public final Builder script(@Nullable Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder onScriptError(@Nullable OnScriptError value) {
            this.onScriptError = value;
            return this;
        }

        public final Builder timeSeriesDimension(@Nullable Boolean value) {
            this.timeSeriesDimension = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BooleanProperty build() {
            this._checkSingleUse();
            return new BooleanProperty(this);
        }
    }
}

