/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.CharFilterBase;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinition;
import co.elastic.clients.elasticsearch._types.analysis.CharFilterDefinitionVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class KuromojiIterationMarkCharFilter
extends CharFilterBase
implements CharFilterDefinitionVariant {
    private final boolean normalizeKana;
    private final boolean normalizeKanji;
    public static final JsonpDeserializer<KuromojiIterationMarkCharFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KuromojiIterationMarkCharFilter::setupKuromojiIterationMarkCharFilterDeserializer);

    private KuromojiIterationMarkCharFilter(Builder builder) {
        super(builder);
        this.normalizeKana = ApiTypeHelper.requireNonNull(builder.normalizeKana, (Object)this, "normalizeKana", false);
        this.normalizeKanji = ApiTypeHelper.requireNonNull(builder.normalizeKanji, (Object)this, "normalizeKanji", false);
    }

    public static KuromojiIterationMarkCharFilter of(Function<Builder, ObjectBuilder<KuromojiIterationMarkCharFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public CharFilterDefinition.Kind _charFilterDefinitionKind() {
        return CharFilterDefinition.Kind.KuromojiIterationMark;
    }

    public final boolean normalizeKana() {
        return this.normalizeKana;
    }

    public final boolean normalizeKanji() {
        return this.normalizeKanji;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "kuromoji_iteration_mark");
        super.serializeInternal(generator, mapper);
        generator.writeKey("normalize_kana");
        generator.write(this.normalizeKana);
        generator.writeKey("normalize_kanji");
        generator.write(this.normalizeKanji);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupKuromojiIterationMarkCharFilterDeserializer(ObjectDeserializer<Builder> op) {
        CharFilterBase.setupCharFilterBaseDeserializer(op);
        op.add(Builder::normalizeKana, JsonpDeserializer.booleanDeserializer(), "normalize_kana");
        op.add(Builder::normalizeKanji, JsonpDeserializer.booleanDeserializer(), "normalize_kanji");
        op.ignore("type");
    }

    public static class Builder
    extends CharFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<KuromojiIterationMarkCharFilter> {
        private Boolean normalizeKana;
        private Boolean normalizeKanji;

        public Builder() {
        }

        private Builder(KuromojiIterationMarkCharFilter instance) {
            this.normalizeKana = instance.normalizeKana;
            this.normalizeKanji = instance.normalizeKanji;
        }

        public final Builder normalizeKana(boolean value) {
            this.normalizeKana = value;
            return this;
        }

        public final Builder normalizeKanji(boolean value) {
            this.normalizeKanji = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KuromojiIterationMarkCharFilter build() {
            this._checkSingleUse();
            return new KuromojiIterationMarkCharFilter(this);
        }
    }
}

