/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.Analyzer;
import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationMode;
import co.elastic.clients.elasticsearch._types.analysis.IcuNormalizationType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IcuAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    private final IcuNormalizationType method;
    private final IcuNormalizationMode mode;
    public static final JsonpDeserializer<IcuAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuAnalyzer::setupIcuAnalyzerDeserializer);

    private IcuAnalyzer(Builder builder) {
        this.method = ApiTypeHelper.requireNonNull(builder.method, this, "method");
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
    }

    public static IcuAnalyzer of(Function<Builder, ObjectBuilder<IcuAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.IcuAnalyzer;
    }

    public final IcuNormalizationType method() {
        return this.method;
    }

    public final IcuNormalizationMode mode() {
        return this.mode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_analyzer");
        generator.writeKey("method");
        this.method.serialize(generator, mapper);
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIcuAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::method, IcuNormalizationType._DESERIALIZER, "method");
        op.add(Builder::mode, IcuNormalizationMode._DESERIALIZER, "mode");
        op.ignore("type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IcuAnalyzer> {
        private IcuNormalizationType method;
        private IcuNormalizationMode mode;

        public Builder() {
        }

        private Builder(IcuAnalyzer instance) {
            this.method = instance.method;
            this.mode = instance.mode;
        }

        public final Builder method(IcuNormalizationType value) {
            this.method = value;
            return this;
        }

        public final Builder mode(IcuNormalizationMode value) {
            this.mode = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IcuAnalyzer build() {
            this._checkSingleUse();
            return new IcuAnalyzer(this);
        }
    }
}

