/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.GeoBounds;
import co.elastic.clients.elasticsearch._types.GeoHashPrecision;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.BucketAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GeoHashGridAggregation
extends BucketAggregationBase
implements AggregationVariant,
JsonpSerializable {
    @Nullable
    private final GeoBounds bounds;
    @Nullable
    private final String field;
    @Nullable
    private final GeoHashPrecision precision;
    @Nullable
    private final Integer shardSize;
    @Nullable
    private final Integer size;
    public static final JsonpDeserializer<GeoHashGridAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoHashGridAggregation::setupGeoHashGridAggregationDeserializer);

    private GeoHashGridAggregation(Builder builder) {
        this.bounds = builder.bounds;
        this.field = builder.field;
        this.precision = builder.precision;
        this.shardSize = builder.shardSize;
        this.size = builder.size;
    }

    public static GeoHashGridAggregation of(Function<Builder, ObjectBuilder<GeoHashGridAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.GeohashGrid;
    }

    @Nullable
    public final GeoBounds bounds() {
        return this.bounds;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final GeoHashPrecision precision() {
        return this.precision;
    }

    @Nullable
    public final Integer shardSize() {
        return this.shardSize;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            this.precision.serialize(generator, mapper);
        }
        if (this.shardSize != null) {
            generator.writeKey("shard_size");
            generator.write(this.shardSize.intValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGeoHashGridAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bounds, GeoBounds._DESERIALIZER, "bounds");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::precision, GeoHashPrecision._DESERIALIZER, "precision");
        op.add(Builder::shardSize, JsonpDeserializer.integerDeserializer(), "shard_size");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GeoHashGridAggregation> {
        @Nullable
        private GeoBounds bounds;
        @Nullable
        private String field;
        @Nullable
        private GeoHashPrecision precision;
        @Nullable
        private Integer shardSize;
        @Nullable
        private Integer size;

        public Builder() {
        }

        private Builder(GeoHashGridAggregation instance) {
            this.bounds = instance.bounds;
            this.field = instance.field;
            this.precision = instance.precision;
            this.shardSize = instance.shardSize;
            this.size = instance.size;
        }

        public final Builder bounds(@Nullable GeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<GeoBounds.Builder, ObjectBuilder<GeoBounds>> fn) {
            return this.bounds(fn.apply(new GeoBounds.Builder()).build());
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder precision(@Nullable GeoHashPrecision value) {
            this.precision = value;
            return this;
        }

        public final Builder precision(Function<GeoHashPrecision.Builder, ObjectBuilder<GeoHashPrecision>> fn) {
            return this.precision(fn.apply(new GeoHashPrecision.Builder()).build());
        }

        public final Builder shardSize(@Nullable Integer value) {
            this.shardSize = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GeoHashGridAggregation build() {
            this._checkSingleUse();
            return new GeoHashGridAggregation(this);
        }
    }
}

