/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.MultiBucketBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DateHistogramBucket
extends MultiBucketBase {
    @Nullable
    private final String keyAsString;
    private final long key;
    public static final JsonpDeserializer<DateHistogramBucket> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DateHistogramBucket::setupDateHistogramBucketDeserializer);

    private DateHistogramBucket(Builder builder) {
        super(builder);
        this.keyAsString = builder.keyAsString;
        this.key = ApiTypeHelper.requireNonNull(builder.key, (Object)this, "key", 0L);
    }

    public static DateHistogramBucket of(Function<Builder, ObjectBuilder<DateHistogramBucket>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String keyAsString() {
        return this.keyAsString;
    }

    public final long key() {
        return this.key;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.keyAsString != null) {
            generator.writeKey("key_as_string");
            generator.write(this.keyAsString);
        }
        generator.writeKey("key");
        generator.write(this.key);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDateHistogramBucketDeserializer(ObjectDeserializer<Builder> op) {
        MultiBucketBase.setupMultiBucketBaseDeserializer(op);
        op.add(Builder::keyAsString, JsonpDeserializer.stringDeserializer(), "key_as_string");
        op.add(Builder::key, JsonpDeserializer.longDeserializer(), "key");
    }

    public static class Builder
    extends MultiBucketBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DateHistogramBucket> {
        @Nullable
        private String keyAsString;
        private Long key;

        public Builder() {
        }

        private Builder(DateHistogramBucket instance) {
            this.keyAsString = instance.keyAsString;
            this.key = instance.key;
        }

        public final Builder keyAsString(@Nullable String value) {
            this.keyAsString = value;
            return this;
        }

        public final Builder key(long value) {
            this.key = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DateHistogramBucket build() {
            this._checkSingleUse();
            return new DateHistogramBucket(this);
        }
    }
}

