/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.CompositeDateHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeGeoTileGridAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeHistogramAggregation;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeTermsAggregation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompositeAggregationSource
implements JsonpSerializable {
    @Nullable
    private final CompositeTermsAggregation terms;
    @Nullable
    private final CompositeHistogramAggregation histogram;
    @Nullable
    private final CompositeDateHistogramAggregation dateHistogram;
    @Nullable
    private final CompositeGeoTileGridAggregation geotileGrid;
    public static final JsonpDeserializer<CompositeAggregationSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeAggregationSource::setupCompositeAggregationSourceDeserializer);

    private CompositeAggregationSource(Builder builder) {
        this.terms = builder.terms;
        this.histogram = builder.histogram;
        this.dateHistogram = builder.dateHistogram;
        this.geotileGrid = builder.geotileGrid;
    }

    public static CompositeAggregationSource of(Function<Builder, ObjectBuilder<CompositeAggregationSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final CompositeTermsAggregation terms() {
        return this.terms;
    }

    @Nullable
    public final CompositeHistogramAggregation histogram() {
        return this.histogram;
    }

    @Nullable
    public final CompositeDateHistogramAggregation dateHistogram() {
        return this.dateHistogram;
    }

    @Nullable
    public final CompositeGeoTileGridAggregation geotileGrid() {
        return this.geotileGrid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.terms != null) {
            generator.writeKey("terms");
            this.terms.serialize(generator, mapper);
        }
        if (this.histogram != null) {
            generator.writeKey("histogram");
            this.histogram.serialize(generator, mapper);
        }
        if (this.dateHistogram != null) {
            generator.writeKey("date_histogram");
            this.dateHistogram.serialize(generator, mapper);
        }
        if (this.geotileGrid != null) {
            generator.writeKey("geotile_grid");
            this.geotileGrid.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCompositeAggregationSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::terms, CompositeTermsAggregation._DESERIALIZER, "terms");
        op.add(Builder::histogram, CompositeHistogramAggregation._DESERIALIZER, "histogram");
        op.add(Builder::dateHistogram, CompositeDateHistogramAggregation._DESERIALIZER, "date_histogram");
        op.add(Builder::geotileGrid, CompositeGeoTileGridAggregation._DESERIALIZER, "geotile_grid");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CompositeAggregationSource> {
        @Nullable
        private CompositeTermsAggregation terms;
        @Nullable
        private CompositeHistogramAggregation histogram;
        @Nullable
        private CompositeDateHistogramAggregation dateHistogram;
        @Nullable
        private CompositeGeoTileGridAggregation geotileGrid;

        public Builder() {
        }

        private Builder(CompositeAggregationSource instance) {
            this.terms = instance.terms;
            this.histogram = instance.histogram;
            this.dateHistogram = instance.dateHistogram;
            this.geotileGrid = instance.geotileGrid;
        }

        public final Builder terms(@Nullable CompositeTermsAggregation value) {
            this.terms = value;
            return this;
        }

        public final Builder terms(Function<CompositeTermsAggregation.Builder, ObjectBuilder<CompositeTermsAggregation>> fn) {
            return this.terms(fn.apply(new CompositeTermsAggregation.Builder()).build());
        }

        public final Builder histogram(@Nullable CompositeHistogramAggregation value) {
            this.histogram = value;
            return this;
        }

        public final Builder histogram(Function<CompositeHistogramAggregation.Builder, ObjectBuilder<CompositeHistogramAggregation>> fn) {
            return this.histogram(fn.apply(new CompositeHistogramAggregation.Builder()).build());
        }

        public final Builder dateHistogram(@Nullable CompositeDateHistogramAggregation value) {
            this.dateHistogram = value;
            return this;
        }

        public final Builder dateHistogram(Function<CompositeDateHistogramAggregation.Builder, ObjectBuilder<CompositeDateHistogramAggregation>> fn) {
            return this.dateHistogram(fn.apply(new CompositeDateHistogramAggregation.Builder()).build());
        }

        public final Builder geotileGrid(@Nullable CompositeGeoTileGridAggregation value) {
            this.geotileGrid = value;
            return this;
        }

        public final Builder geotileGrid(Function<CompositeGeoTileGridAggregation.Builder, ObjectBuilder<CompositeGeoTileGridAggregation>> fn) {
            return this.geotileGrid(fn.apply(new CompositeGeoTileGridAggregation.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeAggregationSource build() {
            this._checkSingleUse();
            return new CompositeAggregationSource(this);
        }
    }
}

